/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import com.inversoft.rest.ClientResponse;
import io.fusionauth.client.FusionAuthClient;
import io.fusionauth.domain.User;
import io.fusionauth.domain.UserRegistration;
import io.fusionauth.domain.api.user.ImportRequest;
import io.fusionauth.load.Configuration;
import io.fusionauth.load.FusionAuthBaseWorker;
import java.util.ArrayList;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class FusionAuthUserImportWorker
extends FusionAuthBaseWorker {
    private final int batchSize;
    private final UUID configuredApplicationId;
    private final AtomicInteger counter;
    private final int factor;

    public FusionAuthUserImportWorker(FusionAuthClient client, Configuration configuration, AtomicInteger counter) {
        super(client, configuration);
        this.counter = counter;
        this.configuredApplicationId = configuration.hasProperty("applicationId") ? UUID.fromString(configuration.getString("applicationId")) : null;
        this.batchSize = configuration.getInteger("batchSize");
        this.factor = configuration.getInteger("factor");
    }

    @Override
    public boolean execute() {
        int offset = this.counter.get();
        System.out.println("Importing users with offset: " + offset);
        for (int ti = 1; ti <= this.tenantCount; ++ti) {
            ArrayList<User> users = new ArrayList<User>();
            for (int j = 0; j < this.batchSize; ++j) {
                this.setUserIndex(offset + ti + j * this.tenantCount);
                User user = new User();
                user.active = true;
                user.email = "load_user_" + this.userIndex + "@fusionauth.io";
                user.password = "11e7ea7b-784d-4687-bf2d-4f8ee479a4dd11e7ea7b-784d-4687-bf2d-4f8ee479a4dd";
                user.factor = this.factor;
                user.data.put("externalId", FusionAuthUserImportWorker.secureString(20, "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"));
                user.tenantId = this.tenantId;
                UUID registrationAppId = this.configuredApplicationId != null ? this.configuredApplicationId : this.applicationId;
                UserRegistration userRegistration = (UserRegistration)((UserRegistration)new UserRegistration().with(r -> {
                    r.applicationId = registrationAppId;
                })).with(r -> r.roles.add("user"));
                user.getRegistrations().add(userRegistration);
                users.add(user);
            }
            ClientResponse result = this.tenantScopedClient.importUsers(new ImportRequest(users));
            if (!result.wasSuccessful()) {
                this.printErrors(result);
                continue;
            }
            System.out.println("Imported " + users.size() + " users for tenant " + this.tenantIndex);
        }
        this.counter.addAndGet(this.batchSize * this.tenantCount);
        return true;
    }
}

