/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import com.inversoft.rest.ClientResponse;
import com.inversoft.rest.FormDataBodyHandler;
import com.inversoft.rest.RESTClient;
import com.inversoft.rest.TextResponseHandler;
import io.fusionauth.client.FusionAuthClient;
import io.fusionauth.load.BaseWorker;
import io.fusionauth.load.Configuration;
import java.util.List;
import java.util.Map;
import java.util.Random;

public class FusionAuthOAuth2AuthorizeWorker
extends BaseWorker {
    public static OAUth2Timing timing = new OAUth2Timing();
    private final String baseURL;
    private final FusionAuthClient client;
    private final String clientId;
    private final String clientSecret;
    private final int loginLowerBound;
    private final int loginUpperBound;
    private final String redirectURI;

    public FusionAuthOAuth2AuthorizeWorker(FusionAuthClient client, Configuration configuration) {
        super(configuration);
        this.baseURL = configuration.getString("url");
        this.client = client;
        this.clientId = configuration.getString("client_id");
        this.clientSecret = configuration.getString("client_secret");
        this.redirectURI = configuration.getString("redirect_uri");
        this.loginLowerBound = configuration.getInteger("loginLowerBound", 0);
        this.loginUpperBound = configuration.getInteger("loginUpperBound", 1000000);
    }

    @Override
    public boolean execute() {
        int random = new Random().nextInt(this.loginUpperBound - this.loginLowerBound + 1) + this.loginLowerBound;
        String email = "load_user_" + random + "@fusionauth.io";
        try {
            long start = System.currentTimeMillis();
            ClientResponse getResponse = new RESTClient(Void.TYPE, Void.TYPE).url(this.baseURL + "/oauth2/authorize").urlParameter("client_id", this.clientId).urlParameter("response_type", "code").urlParameter("redirect_uri", this.redirectURI).followRedirects(false).connectTimeout(7000).readTimeout(7000).get().go();
            FusionAuthOAuth2AuthorizeWorker.timing.render += System.currentTimeMillis() - start;
            if (getResponse.status == 200) {
                start = System.currentTimeMillis();
                ClientResponse postResponse = new RESTClient(Void.TYPE, String.class).url(this.baseURL + "/oauth2/authorize").bodyHandler((RESTClient.BodyHandler)new FormDataBodyHandler(Map.of("client_id", List.of(this.clientId), "client_secret", List.of(this.clientSecret), "loginId", List.of(email), "password", List.of("11e7ea7b-784d-4687-bf2d-4f8ee479a4dd11e7ea7b-784d-4687-bf2d-4f8ee479a4dd"), "redirect_uri", List.of(this.redirectURI), "response_type", List.of("code")))).errorResponseHandler((RESTClient.ResponseHandler)new TextResponseHandler()).followRedirects(false).connectTimeout(7000).readTimeout(7000).post().go();
                FusionAuthOAuth2AuthorizeWorker.timing.post += System.currentTimeMillis() - start;
                if (postResponse.status == 302) {
                    List header = (List)postResponse.headers.get("location");
                    if (header == null) {
                        System.out.println("Fail, cannot handle a redirect that does not have a Location header");
                        return false;
                    }
                    String location = (String)header.getFirst();
                    if (location.startsWith("/oauth2/consent")) {
                        ClientResponse consentResponse = new RESTClient(Void.TYPE, Void.TYPE).url(this.baseURL + location).followRedirects(false).cookies(postResponse.getCookies()).connectTimeout(7000).readTimeout(7000).get().go();
                        if (consentResponse.status == 302) {
                            location = (String)((List)consentResponse.headers.get("location")).getFirst();
                        }
                    }
                    int index = location.indexOf("?code=") + 6;
                    String authCode = location.substring(index, location.indexOf(38, index));
                    start = System.currentTimeMillis();
                    this.client.connectTimeout = 7000;
                    this.client.readTimeout = 7000;
                    ClientResponse tokenResponse = this.client.exchangeOAuthCodeForAccessToken(authCode, this.clientId, this.clientSecret, this.redirectURI);
                    if (tokenResponse.wasSuccessful()) {
                        FusionAuthOAuth2AuthorizeWorker.timing.token += System.currentTimeMillis() - start;
                        return true;
                    }
                    System.out.println("/oauth2/token Fail [" + tokenResponse.status + "]");
                    if (tokenResponse.exception != null) {
                        System.out.println(tokenResponse.exception);
                    }
                } else {
                    System.out.println("Whoops! Post to /oauth2/authorized returned [" + postResponse.status + "]");
                    System.out.println((String)postResponse.errorResponse);
                    System.out.println(postResponse.exception);
                }
            } else if (getResponse.status == 302) {
                System.out.println("Whoops, not coded for SSO redirect yet.");
            } else {
                System.out.println("Unexpected status code: " + getResponse.status);
            }
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        return false;
    }

    public static class OAUth2Timing {
        public long post;
        public long render;
        public long token;
    }
}

