/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import com.inversoft.rest.ClientResponse;
import io.fusionauth.client.FusionAuthClient;
import io.fusionauth.domain.User;
import io.fusionauth.domain.UserRegistration;
import io.fusionauth.domain.api.user.RegistrationRequest;
import io.fusionauth.load.Configuration;
import io.fusionauth.load.FusionAuthBaseWorker;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;

public class FusionAuthRegistrationWorker
extends FusionAuthBaseWorker {
    private final UUID configuredApplicationId;
    private final AtomicInteger counter;
    private final String encryptionScheme;
    private final int factor;

    public FusionAuthRegistrationWorker(FusionAuthClient client, Configuration configuration, AtomicInteger counter) {
        super(client, configuration);
        this.counter = counter;
        this.configuredApplicationId = configuration.hasProperty("applicationId") ? UUID.fromString(configuration.getString("applicationId")) : null;
        this.factor = configuration.getInteger("factor");
        this.encryptionScheme = configuration.getString("encryptionScheme");
    }

    @Override
    public boolean execute() {
        this.setUserIndex(this.counter.incrementAndGet());
        User user = new User();
        user.email = "load_user_" + this.userIndex + "@fusionauth.io";
        user.password = "11e7ea7b-784d-4687-bf2d-4f8ee479a4dd11e7ea7b-784d-4687-bf2d-4f8ee479a4dd";
        user.encryptionScheme = this.encryptionScheme;
        user.factor = this.factor;
        user.data.put("externalId", FusionAuthRegistrationWorker.secureString(20, "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"));
        user.tenantId = this.tenantId;
        UUID registrationAppId = this.configuredApplicationId != null ? this.configuredApplicationId : this.applicationId;
        UserRegistration userRegistration = (UserRegistration)((UserRegistration)new UserRegistration().with(r -> {
            r.applicationId = registrationAppId;
        })).with(r -> r.roles.add("user"));
        ClientResponse result = this.tenantScopedClient.register(null, new RegistrationRequest(null, user, userRegistration));
        if (result.wasSuccessful()) {
            return true;
        }
        this.printErrors(result);
        return false;
    }
}

