/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.load;

import com.inversoft.json.ToString;
import java.time.Duration;
import java.time.Instant;

public class Sample {
    public String message;
    public Instant start;
    public Instant stop;
    public boolean succeeded;

    public Sample(boolean succeeded, Instant start, Instant stop) {
        this(succeeded, start, stop, null);
    }

    public Sample(boolean succeeded, Instant start, Instant stop, String message) {
        this.succeeded = succeeded;
        this.start = start;
        this.stop = stop;
        this.message = message;
    }

    public static Sample fail(Instant start, Instant stop) {
        return Sample.pass(start, stop, null);
    }

    public static Sample fail(Instant start, Instant stop, String message) {
        return new Sample(false, start, stop, message);
    }

    public static Sample pass(Instant start, Instant stop) {
        return Sample.pass(start, stop, null);
    }

    public static Sample pass(Instant start, Instant stop, String message) {
        return new Sample(true, start, stop, message);
    }

    public Duration duration() {
        return Duration.between(this.start, this.stop);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

