/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.security;

import io.fusionauth.jwt.domain.Algorithm;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.Signature;
import javax.crypto.Mac;
import javax.net.ssl.SSLContext;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.testng.annotations.Test;

public class BouncyCastleProviderTest {
    @Test(enabled=false)
    public void jca() {
        MessageDigest md;
        Security.insertProviderAt((Provider)new BouncyCastleFipsProvider(), 1);
        for (Algorithm algorithm : Algorithm.values()) {
            try {
                Mac mac = Mac.getInstance(algorithm.getName());
                System.out.println("For algo [" + algorithm.getName() + "] " + mac.getProvider().getClass());
            }
            catch (NoSuchAlgorithmException e) {
                System.out.println("Missing mac algo [" + algorithm.getName() + "]");
            }
        }
        for (Algorithm algorithm : Algorithm.values()) {
            try {
                Signature signature = Signature.getInstance(algorithm.getName());
                System.out.println("For algo [" + algorithm.getName() + "] " + signature.getProvider().getClass());
            }
            catch (NoSuchAlgorithmException e) {
                System.out.println("Missing signature algo [" + algorithm.getName() + "]");
            }
        }
        try {
            md = MessageDigest.getInstance("SHA-512");
            System.out.println("For algo [SHA-512] " + md.getClass() + " " + md.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(e);
        }
        try {
            md = MessageDigest.getInstance("MD5");
            System.out.println("For algo [MD5] " + md.getClass() + " " + md.getProvider());
        }
        catch (NoSuchAlgorithmException e) {
            System.out.println(e);
        }
    }

    @Test(enabled=false)
    public void sslContext() throws Exception {
        Security.insertProviderAt((Provider)new BouncyCastleFipsProvider(), 1);
        SSLContext context = SSLContext.getDefault();
        System.out.println(context);
    }
}

