/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.rsa;

import io.fusionauth.jwt.BaseJWTTest;
import io.fusionauth.jwt.InvalidKeyTypeException;
import io.fusionauth.jwt.rsa.RSASigner;
import io.fusionauth.pem.domain.PEM;
import java.security.PrivateKey;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RSASignerTest
extends BaseJWTTest {
    @Test
    public void test_invalidKey() {
        try {
            RSASigner.newSHA256Signer((String)this.readFile("ec_private_key_p_256.pem"));
            Assert.fail((String)"Expected exception.");
        }
        catch (InvalidKeyTypeException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Expecting a private key of type [RSAPrivateKey], but found ["));
        }
        try {
            RSASigner.newSHA256Signer((PrivateKey)PEM.decode((String)this.readFile((String)"ec_private_key_p_256.pem")).privateKey);
            Assert.fail((String)"Expected exception.");
        }
        catch (InvalidKeyTypeException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Expecting a private key of type [RSAPrivateKey], but found ["));
        }
    }

    @Test
    public void test_privateKey_object() {
        Assert.assertNotNull((Object)RSASigner.newSHA256Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_2048.pem")).privateKey));
        Assert.assertNotNull((Object)RSASigner.newSHA256Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_2048_with_meta.pem")).privateKey));
        Assert.assertNotNull((Object)RSASigner.newSHA256Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_3072.pem")).privateKey));
        Assert.assertNotNull((Object)RSASigner.newSHA256Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_4096.pem")).privateKey));
        Assert.assertNotNull((Object)RSASigner.newSHA384Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_2048.pem")).privateKey));
        Assert.assertNotNull((Object)RSASigner.newSHA384Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_2048_with_meta.pem")).privateKey));
        Assert.assertNotNull((Object)RSASigner.newSHA384Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_3072.pem")).privateKey));
        Assert.assertNotNull((Object)RSASigner.newSHA384Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_4096.pem")).privateKey));
        Assert.assertNotNull((Object)RSASigner.newSHA512Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_2048.pem")).privateKey));
        Assert.assertNotNull((Object)RSASigner.newSHA512Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_2048_with_meta.pem")).privateKey));
        Assert.assertNotNull((Object)RSASigner.newSHA512Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_3072.pem")).privateKey));
        Assert.assertNotNull((Object)RSASigner.newSHA512Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_4096.pem")).privateKey));
        Assert.assertEquals((String)RSASigner.newSHA256Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_2048.pem")).privateKey, (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA256Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_2048_with_meta.pem")).privateKey, (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA256Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_3072.pem")).privateKey, (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA256Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_4096.pem")).privateKey, (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA384Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_2048.pem")).privateKey, (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA384Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_2048_with_meta.pem")).privateKey, (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA384Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_3072.pem")).privateKey, (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA384Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_4096.pem")).privateKey, (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA512Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_2048.pem")).privateKey, (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA512Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_2048_with_meta.pem")).privateKey, (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA512Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_3072.pem")).privateKey, (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA512Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_4096.pem")).privateKey, (String)"abc").getKid(), (String)"abc");
    }

    @Test
    public void test_private_pem_parsing() {
        Assert.assertNotNull((Object)RSASigner.newSHA256Signer((String)this.readFile("rsa_private_key_2048.pem")));
        Assert.assertNotNull((Object)RSASigner.newSHA256Signer((String)this.readFile("rsa_private_key_2048_with_meta.pem")));
        Assert.assertNotNull((Object)RSASigner.newSHA256Signer((String)this.readFile("rsa_private_key_3072.pem")));
        Assert.assertNotNull((Object)RSASigner.newSHA256Signer((String)this.readFile("rsa_private_key_4096.pem")));
        Assert.assertNotNull((Object)RSASigner.newSHA384Signer((String)this.readFile("rsa_private_key_2048.pem")));
        Assert.assertNotNull((Object)RSASigner.newSHA384Signer((String)this.readFile("rsa_private_key_2048_with_meta.pem")));
        Assert.assertNotNull((Object)RSASigner.newSHA384Signer((String)this.readFile("rsa_private_key_3072.pem")));
        Assert.assertNotNull((Object)RSASigner.newSHA384Signer((String)this.readFile("rsa_private_key_4096.pem")));
        Assert.assertNotNull((Object)RSASigner.newSHA512Signer((String)this.readFile("rsa_private_key_2048.pem")));
        Assert.assertNotNull((Object)RSASigner.newSHA512Signer((String)this.readFile("rsa_private_key_2048_with_meta.pem")));
        Assert.assertNotNull((Object)RSASigner.newSHA512Signer((String)this.readFile("rsa_private_key_3072.pem")));
        Assert.assertNotNull((Object)RSASigner.newSHA512Signer((String)this.readFile("rsa_private_key_4096.pem")));
        Assert.assertEquals((String)RSASigner.newSHA256Signer((String)this.readFile("rsa_private_key_2048.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA256Signer((String)this.readFile("rsa_private_key_2048_with_meta.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA256Signer((String)this.readFile("rsa_private_key_3072.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA256Signer((String)this.readFile("rsa_private_key_4096.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA384Signer((String)this.readFile("rsa_private_key_2048.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA384Signer((String)this.readFile("rsa_private_key_2048_with_meta.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA384Signer((String)this.readFile("rsa_private_key_3072.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA384Signer((String)this.readFile("rsa_private_key_4096.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA512Signer((String)this.readFile("rsa_private_key_2048.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA512Signer((String)this.readFile("rsa_private_key_2048_with_meta.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA512Signer((String)this.readFile("rsa_private_key_3072.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)RSASigner.newSHA512Signer((String)this.readFile("rsa_private_key_4096.pem"), (String)"abc").getKid(), (String)"abc");
    }
}

