/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.ed;

import io.fusionauth.jwt.BaseJWTTest;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.jwt.ed.EdDSAVerifier;
import io.fusionauth.pem.domain.PEM;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.List;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EdDSAVerifierTest
extends BaseJWTTest {
    @Test
    public void canVerify() {
        EdDSAVerifier verifier = EdDSAVerifier.newVerifier((Path)this.getPath("ed_dsa_public_key.pem"));
        Assert.assertTrue((boolean)verifier.canVerify(Algorithm.Ed25519));
        PEM pem = PEM.decode((Path)this.getPath("ed_dsa_public_key.pem"));
        EdDSAVerifier.newVerifier((PublicKey)pem.publicKey);
        EdDSAVerifier verifier25519 = EdDSAVerifier.newVerifier((Path)this.getPath("ed_dsa_ed25519_public_key.pem"));
        Assert.assertTrue((boolean)verifier25519.canVerify(Algorithm.Ed25519));
        Assert.assertFalse((boolean)verifier25519.canVerify(Algorithm.Ed448));
        EdDSAVerifier verifier448 = EdDSAVerifier.newVerifier((Path)this.getPath("ed_dsa_ed448_public_key.pem"));
        Assert.assertFalse((boolean)verifier448.canVerify(Algorithm.Ed25519));
        Assert.assertTrue((boolean)verifier448.canVerify(Algorithm.Ed448));
    }

    @Test
    public void decodePrivateKey() throws Exception {
        List<String> privateKeys = List.of("ed_dsa_ed448_private_key.pem", "eddsa_ed448_private_key.pem", "ed_dsa_ed25519_private_key.pem", "ed_dsa_private_key.pem");
        for (String f : privateKeys) {
            String message = "For file [" + f + "] Fips enabled [" + FipsEnabled + "]";
            String encodedPEM = new String(Files.readAllBytes(Paths.get("src/test/resources/" + f, new String[0])));
            Assert.assertTrue((boolean)encodedPEM.contains("-----BEGIN PRIVATE KEY-----"), (String)message);
            PEM pem = PEM.decode((String)encodedPEM);
            Assert.assertNotNull((Object)pem.privateKey, (String)message);
            Assert.assertEquals((String)pem.privateKey.getFormat(), (String)"PKCS#8", (String)message);
            Assert.assertNotNull((Object)pem.publicKey, (String)message);
            Assert.assertEquals((String)pem.publicKey.getFormat(), (String)"X.509", (String)message);
            String expectedAlgorithm = FipsEnabled ? (f.contains("ed448") ? "Ed448" : "Ed25519") : "EdDSA";
            Assert.assertEquals((String)pem.publicKey.getAlgorithm(), (String)expectedAlgorithm, (String)message);
            String publicKeyFile = f.replace("_private_", "_public_");
            String actualPublicPEM = new String(Files.readAllBytes(Paths.get("src/test/resources/" + publicKeyFile, new String[0]))).trim();
            Assert.assertEquals((String)actualPublicPEM, (String)PEM.encode((Key)pem.publicKey), (String)message);
        }
    }

    @Test
    public void decodePublicKey() throws Exception {
        List<String> publicKeys = Arrays.asList("ed_dsa_ed25519_public_key.pem", "ed_dsa_ed448_public_key.pem", "ed_dsa_public_key.pem");
        for (String f : publicKeys) {
            String message = "For file [" + f + "]";
            String encodedPEM = new String(Files.readAllBytes(Paths.get("src/test/resources/" + f, new String[0])));
            Assert.assertTrue((boolean)encodedPEM.contains("-----BEGIN PUBLIC KEY-----"), (String)message);
            Assert.assertTrue((boolean)encodedPEM.contains("-----END PUBLIC KEY-----"), (String)message);
            PEM pem = PEM.decode((String)encodedPEM);
            Assert.assertNotNull((Object)pem.publicKey, (String)message);
            Assert.assertEquals((String)pem.publicKey.getFormat(), (String)"X.509", (String)message);
        }
    }
}

