/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.ed;

import io.fusionauth.jwt.BaseJWTTest;
import io.fusionauth.jwt.MissingVerifierException;
import io.fusionauth.jwt.Signer;
import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.JWT;
import io.fusionauth.jwt.ed.EdDSASigner;
import io.fusionauth.jwt.ed.EdDSAVerifier;
import io.fusionauth.pem.domain.PEM;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PrivateKey;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EdDSASignerTest
extends BaseJWTTest {
    @Test
    public void signAndVerify() throws Exception {
        JWT jwt = new JWT().setSubject("1234567890");
        EdDSASigner signer = EdDSASigner.newSigner((String)new String(Files.readAllBytes(Paths.get("src/test/resources/ed_dsa_private_key.pem", new String[0]))));
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer);
        EdDSAVerifier verifier = EdDSAVerifier.newVerifier((Path)Paths.get("src/test/resources/ed_dsa_public_key.pem", new String[0]));
        JWT actual = JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((String)actual.subject, (String)jwt.subject);
        Assert.assertEquals((String)actual.header.algorithm.name(), (String)"Ed25519");
        EdDSAVerifier verifier448 = EdDSAVerifier.newVerifier((Path)this.getPath("ed_dsa_ed448_public_key.pem"));
        try {
            JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier448});
            Assert.fail((String)"Expected an exception to be thrown.");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof MissingVerifierException));
            Assert.assertEquals((String)e.getMessage(), (String)"No Verifier has been provided for verify a signature signed using [Ed25519]");
        }
    }

    @Test
    public void test_private_pem_parsing() {
        Assert.assertNotNull((Object)EdDSASigner.newSigner((String)this.readFile("ed_dsa_ed25519_private_key.pem")));
        Assert.assertNotNull((Object)EdDSASigner.newSigner((String)this.readFile("ed_dsa_ed448_private_key.pem")));
        Assert.assertNotNull((Object)EdDSASigner.newSigner((PrivateKey)PEM.decode((Path)this.getPath((String)"ed_dsa_ed25519_private_key.pem")).privateKey));
        Assert.assertNotNull((Object)EdDSASigner.newSigner((PrivateKey)PEM.decode((Path)this.getPath((String)"ed_dsa_ed448_private_key.pem")).privateKey));
        Assert.assertNotNull((Object)EdDSASigner.newSigner((String)this.readFile("ed_dsa_ed25519_private_key.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertNotNull((Object)EdDSASigner.newSigner((String)this.readFile("ed_dsa_ed448_private_key.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertNotNull((Object)EdDSASigner.newSigner((PrivateKey)PEM.decode((Path)this.getPath((String)"ed_dsa_ed25519_private_key.pem")).privateKey, (String)"abc").getKid(), (String)"abc");
        Assert.assertNotNull((Object)EdDSASigner.newSigner((PrivateKey)PEM.decode((Path)this.getPath((String)"ed_dsa_ed448_private_key.pem")).privateKey, (String)"abc").getKid(), (String)"abc");
    }
}

