/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.ec;

import io.fusionauth.jwt.BaseJWTTest;
import io.fusionauth.jwt.InvalidKeyTypeException;
import io.fusionauth.jwt.ec.ECSigner;
import io.fusionauth.pem.domain.PEM;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECGenParameterSpec;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ECSignerTest
extends BaseJWTTest {
    @Test
    public void test_invalidKey() {
        try {
            ECSigner.newSHA256Signer((String)this.readFile("rsa_private_key_2048.pem"));
            Assert.fail((String)"Expected exception.");
        }
        catch (InvalidKeyTypeException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Expecting a private key of type [ECPrivateKey], but found ["));
        }
        try {
            ECSigner.newSHA256Signer((PrivateKey)PEM.decode((String)this.readFile((String)"rsa_private_key_2048.pem")).privateKey);
            Assert.fail((String)"Expected exception.");
        }
        catch (InvalidKeyTypeException e) {
            Assert.assertTrue((boolean)e.getMessage().startsWith("Expecting a private key of type [ECPrivateKey], but found ["));
        }
    }

    @Test
    public void round_trip_raw1() throws Exception {
        KeyPairGenerator g = KeyPairGenerator.getInstance("EC");
        ECGenParameterSpec parameterSpec = new ECGenParameterSpec("secp256r1");
        g.initialize(parameterSpec);
        KeyPair pair = g.generateKeyPair();
        Signature signature = Signature.getInstance("SHA256withECDSA");
        signature.initSign(pair.getPrivate());
        String message = "text ecdsa with sha256";
        signature.update(message.getBytes(StandardCharsets.UTF_8));
        byte[] signatureBytes = signature.sign();
        Signature verifier = Signature.getInstance("SHA256withECDSA");
        verifier.initVerify(pair.getPublic());
        verifier.update(message.getBytes(StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)verifier.verify(signatureBytes));
    }

    @Test
    public void round_trip_raw2() throws Exception {
        ECPublicKey publicKey = (ECPublicKey)PEM.decode((String)new String(Files.readAllBytes(Paths.get("src/test/resources/ec_public_key_p_256.pem", new String[0])))).getPublicKey();
        ECPrivateKey privateKey = (ECPrivateKey)PEM.decode((String)new String(Files.readAllBytes(Paths.get("src/test/resources/ec_private_key_p_256.pem", new String[0])))).getPrivateKey();
        Signature signature = Signature.getInstance("SHA256withECDSA");
        signature.initSign(privateKey);
        String message = "text ecdsa with sha256";
        signature.update(message.getBytes(StandardCharsets.UTF_8));
        byte[] signatureBytes = signature.sign();
        Signature verifier = Signature.getInstance("SHA256withECDSA");
        verifier.initVerify(publicKey);
        verifier.update(message.getBytes(StandardCharsets.UTF_8));
        Assert.assertTrue((boolean)verifier.verify(signatureBytes));
    }

    @Test
    public void test_private_pem_parsing() {
        Assert.assertNotNull((Object)ECSigner.newSHA256Signer((String)this.readFile("ec_private_key_p_256.pem")));
        Assert.assertNotNull((Object)ECSigner.newSHA256Signer((String)this.readFile("ec_private_key_p_384.pem")));
        Assert.assertNotNull((Object)ECSigner.newSHA256Signer((String)this.readFile("ec_private_key_p_521.pem")));
        Assert.assertNotNull((Object)ECSigner.newSHA384Signer((String)this.readFile("ec_private_key_p_256.pem")));
        Assert.assertNotNull((Object)ECSigner.newSHA384Signer((String)this.readFile("ec_private_key_p_384.pem")));
        Assert.assertNotNull((Object)ECSigner.newSHA384Signer((String)this.readFile("ec_private_key_p_521.pem")));
        Assert.assertNotNull((Object)ECSigner.newSHA512Signer((String)this.readFile("ec_private_key_p_256.pem")));
        Assert.assertNotNull((Object)ECSigner.newSHA512Signer((String)this.readFile("ec_private_key_p_384.pem")));
        Assert.assertNotNull((Object)ECSigner.newSHA512Signer((String)this.readFile("ec_private_key_p_521.pem")));
        Assert.assertEquals((String)ECSigner.newSHA256Signer((String)this.readFile("ec_private_key_p_256.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)ECSigner.newSHA256Signer((String)this.readFile("ec_private_key_p_384.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)ECSigner.newSHA256Signer((String)this.readFile("ec_private_key_p_521.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)ECSigner.newSHA384Signer((String)this.readFile("ec_private_key_p_256.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)ECSigner.newSHA384Signer((String)this.readFile("ec_private_key_p_384.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)ECSigner.newSHA384Signer((String)this.readFile("ec_private_key_p_521.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)ECSigner.newSHA512Signer((String)this.readFile("ec_private_key_p_256.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)ECSigner.newSHA512Signer((String)this.readFile("ec_private_key_p_384.pem"), (String)"abc").getKid(), (String)"abc");
        Assert.assertEquals((String)ECSigner.newSHA512Signer((String)this.readFile("ec_private_key_p_521.pem"), (String)"abc").getKid(), (String)"abc");
    }
}

