/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt;

import io.fusionauth.jwt.BaseJWTTest;
import io.fusionauth.jwt.InvalidJWTException;
import io.fusionauth.jwt.InvalidJWTSignatureException;
import io.fusionauth.jwt.JWTDecoder;
import io.fusionauth.jwt.MissingSignatureException;
import io.fusionauth.jwt.MissingVerifierException;
import io.fusionauth.jwt.NoneNotAllowedException;
import io.fusionauth.jwt.Signer;
import io.fusionauth.jwt.UnsecuredSigner;
import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.JWT;
import io.fusionauth.jwt.ec.ECSigner;
import io.fusionauth.jwt.ec.ECVerifier;
import io.fusionauth.jwt.hmac.HMACSigner;
import io.fusionauth.jwt.hmac.HMACVerifier;
import io.fusionauth.jwt.rsa.RSAVerifier;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import org.testng.annotations.Test;

public class VulnerabilityTest
extends BaseJWTTest {
    @Test
    public void test_SignedWithoutSignature() {
        JWT inputJwt = new JWT().setSubject("123456789").setIssuedAt(ZonedDateTime.now(ZoneOffset.UTC)).setExpiration(ZonedDateTime.now(ZoneOffset.UTC).plusHours(2L));
        String encodedJWT = JWT.getEncoder().encode(inputJwt, (Signer)HMACSigner.newSHA256Signer((String)"secret"));
        String encodedJWTNoSignature = encodedJWT.substring(0, encodedJWT.lastIndexOf(46) + 1);
        this.expectException(NoneNotAllowedException.class, () -> JWT.getDecoder().decode(encodedJWTNoSignature, new Verifier[]{HMACVerifier.newVerifier((String)"secret")}));
        this.expectException(MissingSignatureException.class, () -> JWT.getDecoder().decode(encodedJWTNoSignature, new Verifier[0]));
    }

    @Test
    public void test_ECDSA_CVE_2022_21449() {
        JWT inputJwt = new JWT().setSubject("123456789").setIssuedAt(ZonedDateTime.now(ZoneOffset.UTC)).setExpiration(ZonedDateTime.now(ZoneOffset.UTC).plusHours(2L));
        for (String alg : Arrays.asList("256", "384", "521")) {
            ECSigner signer = alg.equals("256") ? ECSigner.newSHA256Signer((String)this.readFile("ec_private_key_p_" + alg + ".pem")) : (alg.equals("384") ? ECSigner.newSHA384Signer((String)this.readFile("ec_private_key_p_" + alg + ".pem")) : ECSigner.newSHA512Signer((String)this.readFile("ec_private_key_p_" + alg + ".pem")));
            String encodedJWT = JWT.getEncoder().encode(inputJwt, (Signer)signer);
            String hackedEncodedJWT = encodedJWT.substring(0, encodedJWT.lastIndexOf(46) + 1) + Base64.getUrlEncoder().encodeToString(new byte[64]);
            this.expectException(InvalidJWTSignatureException.class, () -> JWT.getDecoder().decode(hackedEncodedJWT, new Verifier[]{ECVerifier.newVerifier((String)this.readFile("ec_public_key_p_" + alg + ".pem"))}));
        }
    }

    @Test
    public void test_encodedJwtWithSignatureRemoved() {
        JWT jwt = new JWT().setSubject("art");
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)HMACSigner.newSHA256Signer((String)"secret"));
        String hackedJWT = encodedJWT.substring(0, encodedJWT.lastIndexOf(46));
        this.expectException(InvalidJWTException.class, () -> JWT.getDecoder().decode(hackedJWT, new Verifier[]{HMACVerifier.newVerifier((String)"secret")}));
    }

    @Test
    public void test_noVerification() {
        JWT jwt = new JWT().setSubject("art");
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)HMACSigner.newSHA256Signer((String)"secret"));
        this.expectException(MissingVerifierException.class, () -> JWT.getDecoder().decode(encodedJWT, new Verifier[0]));
    }

    @Test
    public void test_unsecuredJWT_validation() {
        JWT jwt = new JWT().setSubject("123456789");
        UnsecuredSigner signer = new UnsecuredSigner();
        HMACVerifier hmacVerifier = HMACVerifier.newVerifier((String)"too many secrets");
        String encodedUnsecuredJWT = JWT.getEncoder().encode(jwt, (Signer)signer);
        this.expectException(NoneNotAllowedException.class, () -> VulnerabilityTest.lambda$test_unsecuredJWT_validation$5(encodedUnsecuredJWT, (Verifier)hmacVerifier));
        String encodedUnsecuredJWT_withKid = JWT.getEncoder().encode(jwt, (Signer)signer, header -> header.set("kid", (Object)"abc"));
        String encodedUnsecuredJWT_withoutKid = JWT.getEncoder().encode(jwt, (Signer)signer);
        HashMap<String, HMACVerifier> verifierMap = new HashMap<String, HMACVerifier>();
        verifierMap.put(null, hmacVerifier);
        verifierMap.put("abc", hmacVerifier);
        this.expectException(NoneNotAllowedException.class, () -> JWT.getDecoder().decode(encodedUnsecuredJWT_withKid, verifierMap));
        this.expectException(NoneNotAllowedException.class, () -> JWT.getDecoder().decode(encodedUnsecuredJWT_withoutKid, verifierMap));
    }

    @Test
    public void test_vulnerability_HMAC_forgery() throws Exception {
        JWT jwt = new JWT().setSubject("123456789");
        HMACSigner hackedSigner = HMACSigner.newSHA512Signer((String)new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_public_key_2048.pem", new String[0]))));
        String hmacSignedJWT = JWT.getEncoder().encode(jwt, (Signer)hackedSigner, h -> h.set("kid", (Object)"abc"));
        RSAVerifier rsaVerifier = RSAVerifier.newVerifier((String)new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_public_key_2048.pem", new String[0]))));
        HMACVerifier hmacVerifier = HMACVerifier.newVerifier((String)"secret");
        this.expectException(InvalidJWTSignatureException.class, () -> VulnerabilityTest.lambda$test_vulnerability_HMAC_forgery$10(hmacSignedJWT, (Verifier)rsaVerifier, (Verifier)hmacVerifier));
        HashMap<String, Object> verifierMap = new HashMap<String, Object>();
        verifierMap.put("abc", rsaVerifier);
        verifierMap.put("def", hmacVerifier);
        this.expectException(MissingVerifierException.class, () -> new JWTDecoder().decode(hmacSignedJWT, verifierMap));
        String hmacSignedJWTTakeTwo = JWT.getEncoder().encode(jwt, (Signer)hackedSigner, h -> h.set("kid", (Object)"def"));
        this.expectException(InvalidJWTSignatureException.class, () -> VulnerabilityTest.lambda$test_vulnerability_HMAC_forgery$13(hmacSignedJWTTakeTwo, (Verifier)rsaVerifier, (Verifier)hmacVerifier));
        this.expectException(InvalidJWTSignatureException.class, () -> new JWTDecoder().decode(hmacSignedJWTTakeTwo, verifierMap));
    }

    private static /* synthetic */ void lambda$test_vulnerability_HMAC_forgery$13(String hmacSignedJWTTakeTwo, Verifier rsaVerifier, Verifier hmacVerifier) throws Exception {
        new JWTDecoder().decode(hmacSignedJWTTakeTwo, new Verifier[]{rsaVerifier, hmacVerifier});
    }

    private static /* synthetic */ void lambda$test_vulnerability_HMAC_forgery$10(String hmacSignedJWT, Verifier rsaVerifier, Verifier hmacVerifier) throws Exception {
        new JWTDecoder().decode(hmacSignedJWT, new Verifier[]{rsaVerifier, hmacVerifier});
    }

    private static /* synthetic */ void lambda$test_unsecuredJWT_validation$5(String encodedUnsecuredJWT, Verifier hmacVerifier) throws Exception {
        JWT.getDecoder().decode(encodedUnsecuredJWT, new Verifier[]{hmacVerifier});
    }
}

