/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt;

import io.fusionauth.BaseTest;
import io.fusionauth.jwks.domain.JSONWebKey;
import io.fusionauth.jwt.JWTUtils;
import io.fusionauth.jwt.Signer;
import io.fusionauth.jwt.UnsecuredSigner;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.jwt.domain.JWT;
import io.fusionauth.jwt.domain.KeyPair;
import io.fusionauth.jwt.domain.KeyType;
import io.fusionauth.jwt.hmac.HMACSigner;
import io.fusionauth.pem.domain.PEM;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.EdECPrivateKey;
import java.security.interfaces.EdECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Base64;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JWTUtilsTest
extends BaseTest {
    @Test
    public void decodePayload() {
        JWT jwt = new JWT().setSubject("123456789");
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)HMACSigner.newSHA512Signer((String)"secret1"));
        Assert.assertEquals((String)JWTUtils.decodePayload((String)encodedJWT).subject, (String)"123456789");
        Assert.assertEquals((Object)JWTUtils.decodeHeader((String)encodedJWT).algorithm, (Object)Algorithm.HS512);
        String unsecuredJWT = JWT.getEncoder().encode(jwt, (Signer)new UnsecuredSigner());
        Assert.assertEquals((String)JWTUtils.decodePayload((String)unsecuredJWT).subject, (String)"123456789");
        Assert.assertEquals((Object)JWTUtils.decodeHeader((String)unsecuredJWT).algorithm, (Object)Algorithm.none);
    }

    @Test
    public void generateECKey() {
        KeyPair keyPair256 = JWTUtils.generate256_ECKeyPair();
        ECPrivateKey privateKey256 = (ECPrivateKey)PEM.decode((String)keyPair256.privateKey).getPrivateKey();
        ECPublicKey publicKey256 = (ECPublicKey)PEM.decode((String)keyPair256.publicKey).getPublicKey();
        Assert.assertEquals((String)privateKey256.getAlgorithm(), (String)"EC");
        Assert.assertEquals((String)privateKey256.getFormat(), (String)"PKCS#8");
        Assert.assertEquals((int)privateKey256.getParams().getCurve().getField().getFieldSize(), (int)256);
        Assert.assertEquals((String)publicKey256.getAlgorithm(), (String)"EC");
        Assert.assertEquals((String)publicKey256.getFormat(), (String)"X.509");
        Assert.assertEquals((int)publicKey256.getParams().getCurve().getField().getFieldSize(), (int)256);
        this.assertPrefix(keyPair256.privateKey, "-----BEGIN PRIVATE KEY-----");
        this.assertSuffix(keyPair256.privateKey, "-----END PRIVATE KEY-----");
        this.assertPrefix(keyPair256.publicKey, "-----BEGIN PUBLIC KEY-----");
        this.assertSuffix(keyPair256.publicKey, "-----END PUBLIC KEY-----");
        String actualPrivateKey256 = PEM.encode((PrivateKey)privateKey256, (PublicKey)publicKey256);
        String actualPublicKey256 = PEM.encode((Key)publicKey256);
        Assert.assertEquals((String)actualPrivateKey256, (String)keyPair256.privateKey);
        Assert.assertEquals((String)actualPublicKey256, (String)keyPair256.publicKey);
        KeyPair keyPair384 = JWTUtils.generate384_ECKeyPair();
        ECPrivateKey privateKey384 = (ECPrivateKey)PEM.decode((String)keyPair384.privateKey).getPrivateKey();
        ECPublicKey publicKey384 = (ECPublicKey)PEM.decode((String)keyPair384.publicKey).getPublicKey();
        Assert.assertEquals((String)privateKey384.getAlgorithm(), (String)"EC");
        Assert.assertEquals((String)privateKey384.getFormat(), (String)"PKCS#8");
        Assert.assertEquals((int)privateKey384.getParams().getCurve().getField().getFieldSize(), (int)384);
        Assert.assertEquals((String)publicKey384.getAlgorithm(), (String)"EC");
        Assert.assertEquals((String)publicKey384.getFormat(), (String)"X.509");
        Assert.assertEquals((int)publicKey384.getParams().getCurve().getField().getFieldSize(), (int)384);
        this.assertPrefix(keyPair384.privateKey, "-----BEGIN PRIVATE KEY-----");
        this.assertSuffix(keyPair384.privateKey, "-----END PRIVATE KEY-----");
        this.assertPrefix(keyPair384.publicKey, "-----BEGIN PUBLIC KEY-----");
        this.assertSuffix(keyPair384.publicKey, "-----END PUBLIC KEY-----");
        String actualPrivateKey384 = PEM.encode((PrivateKey)privateKey384, (PublicKey)publicKey384);
        String actualPublicKey384 = PEM.encode((Key)publicKey384);
        Assert.assertEquals((String)actualPrivateKey384, (String)keyPair384.privateKey);
        Assert.assertEquals((String)actualPublicKey384, (String)keyPair384.publicKey);
        KeyPair keyPair521 = JWTUtils.generate521_ECKeyPair();
        ECPrivateKey privateKey521 = (ECPrivateKey)PEM.decode((String)keyPair521.privateKey).getPrivateKey();
        ECPublicKey publicKey521 = (ECPublicKey)PEM.decode((String)keyPair521.publicKey).getPublicKey();
        Assert.assertEquals((String)privateKey521.getAlgorithm(), (String)"EC");
        Assert.assertEquals((String)privateKey521.getFormat(), (String)"PKCS#8");
        Assert.assertEquals((int)privateKey521.getParams().getCurve().getField().getFieldSize(), (int)521);
        Assert.assertEquals((String)publicKey521.getAlgorithm(), (String)"EC");
        Assert.assertEquals((String)publicKey521.getFormat(), (String)"X.509");
        Assert.assertEquals((int)publicKey521.getParams().getCurve().getField().getFieldSize(), (int)521);
        this.assertPrefix(keyPair521.privateKey, "-----BEGIN PRIVATE KEY-----");
        this.assertSuffix(keyPair521.privateKey, "-----END PRIVATE KEY-----");
        this.assertPrefix(keyPair521.publicKey, "-----BEGIN PUBLIC KEY-----");
        this.assertSuffix(keyPair521.publicKey, "-----END PUBLIC KEY-----");
        String actualPrivateKey521 = PEM.encode((PrivateKey)privateKey521, (PublicKey)publicKey521);
        String actualPublicKey521 = PEM.encode((Key)publicKey521);
        Assert.assertEquals((String)actualPrivateKey521, (String)keyPair521.privateKey);
        Assert.assertEquals((String)actualPublicKey521, (String)keyPair521.publicKey);
    }

    @Test
    public void generate_ed25519_EdDSAKeyPair() {
        KeyPair keyPair = JWTUtils.generate_ed25519_EdDSAKeyPair();
        EdECPrivateKey privateKey = (EdECPrivateKey)PEM.decode((String)keyPair.privateKey).getPrivateKey();
        EdECPublicKey publicKey = (EdECPublicKey)PEM.decode((String)keyPair.publicKey).getPublicKey();
        Assert.assertEquals((String)privateKey.getAlgorithm(), (String)(FipsEnabled ? "Ed25519" : "EdDSA"));
        Assert.assertEquals((String)privateKey.getFormat(), (String)"PKCS#8");
        Assert.assertEquals((String)privateKey.getParams().getName(), (String)"Ed25519");
        Assert.assertEquals((int)privateKey.getBytes().orElseThrow().length, (int)32);
        Assert.assertEquals((String)publicKey.getAlgorithm(), (String)(FipsEnabled ? "Ed25519" : "EdDSA"));
        Assert.assertEquals((String)publicKey.getFormat(), (String)"X.509");
    }

    @Test
    public void generate_ed448_EdDSAKeyPair() {
        KeyPair keyPair = JWTUtils.generate_ed448_EdDSAKeyPair();
        EdECPrivateKey privateKey = (EdECPrivateKey)PEM.decode((String)keyPair.privateKey).getPrivateKey();
        EdECPublicKey publicKey = (EdECPublicKey)PEM.decode((String)keyPair.publicKey).getPublicKey();
        Assert.assertEquals((String)privateKey.getAlgorithm(), (String)(FipsEnabled ? "Ed448" : "EdDSA"));
        Assert.assertEquals((String)privateKey.getFormat(), (String)"PKCS#8");
        Assert.assertEquals((String)privateKey.getParams().getName(), (String)"Ed448");
        Assert.assertEquals((int)privateKey.getBytes().orElseThrow().length, (int)57);
        Assert.assertEquals((String)publicKey.getAlgorithm(), (String)(FipsEnabled ? "Ed448" : "EdDSA"));
        Assert.assertEquals((String)publicKey.getFormat(), (String)"X.509");
    }

    @Test
    public void generateRSAPSS_key() {
        KeyPair keyPair2048 = JWTUtils.generate2048_RSAPSSKeyPair();
        RSAPrivateKey privateKey2048 = (RSAPrivateKey)PEM.decode((String)keyPair2048.privateKey).getPrivateKey();
        RSAPublicKey publicKey2048 = (RSAPublicKey)PEM.decode((String)keyPair2048.publicKey).getPublicKey();
        Assert.assertEquals((int)privateKey2048.getModulus().bitLength(), (int)2048);
        Assert.assertEquals((String)privateKey2048.getAlgorithm(), (String)"RSASSA-PSS");
        Assert.assertEquals((String)privateKey2048.getFormat(), (String)"PKCS#8");
        Assert.assertEquals((int)publicKey2048.getModulus().bitLength(), (int)2048);
        Assert.assertEquals((String)publicKey2048.getAlgorithm(), (String)"RSASSA-PSS");
        Assert.assertEquals((String)publicKey2048.getFormat(), (String)"X.509");
        this.assertPrefix(keyPair2048.privateKey, "-----BEGIN PRIVATE KEY-----");
        this.assertSuffix(keyPair2048.privateKey, "-----END PRIVATE KEY-----");
        this.assertPrefix(keyPair2048.publicKey, "-----BEGIN PUBLIC KEY-----");
        this.assertSuffix(keyPair2048.publicKey, "-----END PUBLIC KEY-----");
        String actualPrivateKey2048 = PEM.encode((Key)privateKey2048);
        String actualPublicKey2048 = PEM.encode((Key)publicKey2048);
        Assert.assertEquals((String)actualPrivateKey2048, (String)keyPair2048.privateKey);
        Assert.assertEquals((String)actualPublicKey2048, (String)keyPair2048.publicKey);
        KeyPair keyPair3072 = JWTUtils.generate3072_RSAPSSKeyPair();
        RSAPrivateKey privateKey3072 = (RSAPrivateKey)PEM.decode((String)keyPair3072.privateKey).getPrivateKey();
        RSAPublicKey publicKey3072 = (RSAPublicKey)PEM.decode((String)keyPair3072.publicKey).getPublicKey();
        Assert.assertEquals((int)privateKey3072.getModulus().bitLength(), (int)3072);
        Assert.assertEquals((String)privateKey3072.getAlgorithm(), (String)"RSASSA-PSS");
        Assert.assertEquals((String)privateKey3072.getFormat(), (String)"PKCS#8");
        Assert.assertEquals((int)publicKey3072.getModulus().bitLength(), (int)3072);
        Assert.assertEquals((String)publicKey3072.getAlgorithm(), (String)"RSASSA-PSS");
        Assert.assertEquals((String)publicKey3072.getFormat(), (String)"X.509");
        this.assertPrefix(keyPair3072.privateKey, "-----BEGIN PRIVATE KEY-----");
        this.assertSuffix(keyPair3072.privateKey, "-----END PRIVATE KEY-----");
        this.assertPrefix(keyPair3072.publicKey, "-----BEGIN PUBLIC KEY-----");
        this.assertSuffix(keyPair3072.publicKey, "-----END PUBLIC KEY-----");
        String actualPrivateKey3072 = PEM.encode((Key)privateKey3072);
        String actualPublicKey3072 = PEM.encode((Key)publicKey3072);
        Assert.assertEquals((String)actualPrivateKey3072, (String)keyPair3072.privateKey);
        Assert.assertEquals((String)actualPublicKey3072, (String)keyPair3072.publicKey);
        KeyPair keyPair4096 = JWTUtils.generate4096_RSAPSSKeyPair();
        RSAPrivateKey privateKey4096 = (RSAPrivateKey)PEM.decode((String)keyPair4096.privateKey).getPrivateKey();
        RSAPublicKey publicKey4096 = (RSAPublicKey)PEM.decode((String)keyPair4096.publicKey).getPublicKey();
        Assert.assertEquals((int)privateKey4096.getModulus().bitLength(), (int)4096);
        Assert.assertEquals((String)privateKey4096.getAlgorithm(), (String)"RSASSA-PSS");
        Assert.assertEquals((String)privateKey4096.getFormat(), (String)"PKCS#8");
        Assert.assertEquals((int)publicKey4096.getModulus().bitLength(), (int)4096);
        Assert.assertEquals((String)publicKey4096.getAlgorithm(), (String)"RSASSA-PSS");
        Assert.assertEquals((String)publicKey4096.getFormat(), (String)"X.509");
        this.assertPrefix(keyPair4096.privateKey, "-----BEGIN PRIVATE KEY-----");
        this.assertSuffix(keyPair4096.privateKey, "-----END PRIVATE KEY-----");
        this.assertPrefix(keyPair4096.publicKey, "-----BEGIN PUBLIC KEY-----");
        this.assertSuffix(keyPair4096.publicKey, "-----END PUBLIC KEY-----");
        String actualPrivateKey4096 = PEM.encode((Key)privateKey4096);
        String actualPublicKey4096 = PEM.encode((Key)publicKey4096);
        Assert.assertEquals((String)actualPrivateKey4096, (String)keyPair4096.privateKey);
        Assert.assertEquals((String)actualPublicKey4096, (String)keyPair4096.publicKey);
    }

    @Test
    public void generateRSAKey() {
        KeyPair keyPair2048 = JWTUtils.generate2048_RSAKeyPair();
        RSAPrivateKey privateKey2048 = (RSAPrivateKey)PEM.decode((String)keyPair2048.privateKey).getPrivateKey();
        RSAPublicKey publicKey2048 = (RSAPublicKey)PEM.decode((String)keyPair2048.publicKey).getPublicKey();
        Assert.assertEquals((int)privateKey2048.getModulus().bitLength(), (int)2048);
        Assert.assertEquals((String)privateKey2048.getAlgorithm(), (String)"RSA");
        Assert.assertEquals((String)privateKey2048.getFormat(), (String)"PKCS#8");
        Assert.assertEquals((int)publicKey2048.getModulus().bitLength(), (int)2048);
        Assert.assertEquals((String)publicKey2048.getAlgorithm(), (String)"RSA");
        Assert.assertEquals((String)publicKey2048.getFormat(), (String)"X.509");
        this.assertPrefix(keyPair2048.privateKey, "-----BEGIN PRIVATE KEY-----");
        this.assertSuffix(keyPair2048.privateKey, "-----END PRIVATE KEY-----");
        this.assertPrefix(keyPair2048.publicKey, "-----BEGIN PUBLIC KEY-----");
        this.assertSuffix(keyPair2048.publicKey, "-----END PUBLIC KEY-----");
        String actualPrivateKey2048 = PEM.encode((Key)privateKey2048);
        String actualPublicKey2048 = PEM.encode((Key)publicKey2048);
        Assert.assertEquals((String)actualPrivateKey2048, (String)keyPair2048.privateKey);
        Assert.assertEquals((String)actualPublicKey2048, (String)keyPair2048.publicKey);
        KeyPair keyPair3072 = JWTUtils.generate3072_RSAKeyPair();
        RSAPrivateKey privateKey3072 = (RSAPrivateKey)PEM.decode((String)keyPair3072.privateKey).getPrivateKey();
        RSAPublicKey publicKey3072 = (RSAPublicKey)PEM.decode((String)keyPair3072.publicKey).getPublicKey();
        Assert.assertEquals((int)privateKey3072.getModulus().bitLength(), (int)3072);
        Assert.assertEquals((String)privateKey3072.getAlgorithm(), (String)"RSA");
        Assert.assertEquals((String)privateKey3072.getFormat(), (String)"PKCS#8");
        Assert.assertEquals((int)publicKey3072.getModulus().bitLength(), (int)3072);
        Assert.assertEquals((String)publicKey3072.getAlgorithm(), (String)"RSA");
        Assert.assertEquals((String)publicKey3072.getFormat(), (String)"X.509");
        this.assertPrefix(keyPair3072.privateKey, "-----BEGIN PRIVATE KEY-----");
        this.assertSuffix(keyPair3072.privateKey, "-----END PRIVATE KEY-----");
        this.assertPrefix(keyPair3072.publicKey, "-----BEGIN PUBLIC KEY-----");
        this.assertSuffix(keyPair3072.publicKey, "-----END PUBLIC KEY-----");
        String actualPrivateKey3072 = PEM.encode((Key)privateKey3072);
        String actualPublicKey3072 = PEM.encode((Key)publicKey3072);
        Assert.assertEquals((String)actualPrivateKey3072, (String)keyPair3072.privateKey);
        Assert.assertEquals((String)actualPublicKey3072, (String)keyPair3072.publicKey);
        KeyPair keyPair4096 = JWTUtils.generate4096_RSAKeyPair();
        RSAPrivateKey privateKey4096 = (RSAPrivateKey)PEM.decode((String)keyPair4096.privateKey).getPrivateKey();
        RSAPublicKey publicKey4096 = (RSAPublicKey)PEM.decode((String)keyPair4096.publicKey).getPublicKey();
        Assert.assertEquals((int)privateKey4096.getModulus().bitLength(), (int)4096);
        Assert.assertEquals((String)privateKey4096.getAlgorithm(), (String)"RSA");
        Assert.assertEquals((String)privateKey4096.getFormat(), (String)"PKCS#8");
        Assert.assertEquals((int)publicKey4096.getModulus().bitLength(), (int)4096);
        Assert.assertEquals((String)publicKey4096.getAlgorithm(), (String)"RSA");
        Assert.assertEquals((String)publicKey4096.getFormat(), (String)"X.509");
        this.assertPrefix(keyPair4096.privateKey, "-----BEGIN PRIVATE KEY-----");
        this.assertSuffix(keyPair4096.privateKey, "-----END PRIVATE KEY-----");
        this.assertPrefix(keyPair4096.publicKey, "-----BEGIN PUBLIC KEY-----");
        this.assertSuffix(keyPair4096.publicKey, "-----END PUBLIC KEY-----");
        String actualPrivateKey4096 = PEM.encode((Key)privateKey4096);
        String actualPublicKey4096 = PEM.encode((Key)publicKey4096);
        Assert.assertEquals((String)actualPrivateKey4096, (String)keyPair4096.privateKey);
        Assert.assertEquals((String)actualPublicKey4096, (String)keyPair4096.publicKey);
    }

    @Test
    public void hmacSecretLengths() {
        String hmac256 = JWTUtils.generateSHA256_HMACSecret();
        Assert.assertEquals((int)hmac256.length(), (int)44);
        Assert.assertEquals((int)Base64.getDecoder().decode(hmac256.getBytes(StandardCharsets.UTF_8)).length, (int)32);
        String hmac384 = JWTUtils.generateSHA384_HMACSecret();
        Assert.assertEquals((int)hmac384.length(), (int)64);
        Assert.assertEquals((int)Base64.getDecoder().decode(hmac384.getBytes(StandardCharsets.UTF_8)).length, (int)48);
        String hmac512 = JWTUtils.generateSHA512_HMACSecret();
        Assert.assertEquals((int)hmac512.length(), (int)88);
        Assert.assertEquals((int)Base64.getDecoder().decode(hmac512.getBytes(StandardCharsets.UTF_8)).length, (int)64);
    }

    @Test
    public void jws_x5t() {
        String encodedCertificate = "MIIC5jCCAc6gAwIBAgIQNCdDZLmeeL5H6O2BE+aQCjANBgkqhkiG9w0BAQsFADAvMS0wKwYDVQQDEyRBREZTIFNpZ25pbmcgLSB1bWdjb25uZWN0LnVtdXNpYy5jb20wHhcNMTcxMDE4MTUyOTAzWhcNMTgxMDE4MTUyOTAzWjAvMS0wKwYDVQQDEyRBREZTIFNpZ25pbmcgLSB1bWdjb25uZWN0LnVtdXNpYy5jb20wggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAoIBAQDnUl7AwWO1fjpijswRY40bs8jegA4Kz4ycM12h8PqD0CbydWyCnPmY/mzI8EPWsaT3uJ4QaYEEq+taNTu/GB8eFDs1flDb1JNjkZ2ECDZpdwgAS/z+RvI7D+tRARNUU7QvkMAOfFTb3zS4Cx52RoXlp3Bdrtzk9KaO/DJc7IoxLCAWuXL8kxuBRwfPzeQXX/i+wIRtkJAFotOq7j/XxgYO0/UzCenZDAr+Xbl8JfmrkFaegEQFwAC2/jlAP9OYjF39qD+9kI/HP9CcnXxoAIbq8lJkIKvuoURV9mErlel2Oj+tgvveq28NEV36RwqnfAqAIsAT4BTs739JUsnoHnKbAgMBAAEwDQYJKoZIhvcNAQELBQADggEBAGesHLA8V2/4ljxwbjeBsBBk8fJ4DGVufKJJXBit7jb37/9/XVtkVg1Y2IuVoYnzpnOxAZ/Zizp8/HKH2bApqEOcAU3oZ471FZlzXAv1G51S0i1UUD/OWgc3z84pk9AMtWSka26GOWA4pb/Mw/nrBrG3R8NY6ZgLZQqbYR2GQBj5JXbDsJtzYkVXY6N5KmsBekVJ92ddjKMy5SfcGY0j3BFFsBOUpaONWgBFAD2rOH9FnwoY7tcTKa5u4MfwSXMYLal/Vk9kFAtBV2Uqe/MgitB8OgAGYYqGU8VRPVH4K/n8sx5EarZPXcOJkHbI/C70Puc0jxra4e4/2c4HqifMAYQ=";
        byte[] derEncodedCertificate = Base64.getDecoder().decode(encodedCertificate.getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((String)JWTUtils.generateJWS_x5t((String)encodedCertificate), (String)"vDT213a_AF5eRdElKZla9-9dpc8");
        Assert.assertEquals((String)JWTUtils.generateJWS_x5t((String)"SHA-1", (String)encodedCertificate), (String)"vDT213a_AF5eRdElKZla9-9dpc8");
        Assert.assertEquals((String)JWTUtils.generateJWS_x5t((byte[])derEncodedCertificate), (String)"vDT213a_AF5eRdElKZla9-9dpc8");
        Assert.assertEquals((String)JWTUtils.generateJWS_x5t((String)"SHA-1", (byte[])derEncodedCertificate), (String)"vDT213a_AF5eRdElKZla9-9dpc8");
        Assert.assertEquals((String)JWTUtils.generateJWS_x5t((String)"SHA-256", (String)encodedCertificate), (String)"tIFNLfPYY14sM0DLTp6T-BZ3yPaPUPKc8Hnh6evXTeM");
        Assert.assertEquals((String)JWTUtils.generateJWS_x5t((String)"SHA-256", (byte[])derEncodedCertificate), (String)"tIFNLfPYY14sM0DLTp6T-BZ3yPaPUPKc8Hnh6evXTeM");
        Assert.assertEquals((String)JWTUtils.convertFingerprintToThumbprint((String)"BC34F6D776BF005E5E45D12529995AF7EF5DA5CF"), (String)"vDT213a_AF5eRdElKZla9-9dpc8");
        Assert.assertEquals((String)JWTUtils.convertFingerprintToThumbprint((String)"B4814D2DF3D8635E2C3340CB4E9E93F81677C8F68F50F29CF079E1E9EBD74DE3"), (String)"tIFNLfPYY14sM0DLTp6T-BZ3yPaPUPKc8Hnh6evXTeM");
        Assert.assertEquals((String)JWTUtils.convertThumbprintToFingerprint((String)"vDT213a_AF5eRdElKZla9-9dpc8"), (String)"BC34F6D776BF005E5E45D12529995AF7EF5DA5CF");
        Assert.assertEquals((String)JWTUtils.convertThumbprintToFingerprint((String)"tIFNLfPYY14sM0DLTp6T-BZ3yPaPUPKc8Hnh6evXTeM"), (String)"B4814D2DF3D8635E2C3340CB4E9E93F81677C8F68F50F29CF079E1E9EBD74DE3");
    }

    @Test
    public void jws_kid_rsaControl() {
        JSONWebKey rsaKey = new JSONWebKey();
        rsaKey.kty = KeyType.RSA;
        rsaKey.n = "0vx7agoebGcQSuuPiLJXZptN9nndrQmbXEps2aiAFbWhM78LhWx4cbbfAAtVT86zwu1RK7aPFFxuhDR1L6tSoc_BJECPebWKRXjBZCiFV4n3oknjhMstn64tZ_2W-5JsGY4Hc5n9yBXArwl93lqt7_RN5w6Cf0h4QyQ5v-65YGjQR0_FDW2QvzqY368QQMicAtaSqzs8KJZgnYb9c7d0zgdAZHzu6qMQvRL5hajrn1n91CbOpbISD08qNLyrdkt-bFTWhAI4vMQFh6WeZu0fM4lFd2NcRwr3XPksINHaQ-G_xBniIqbw0Ls1jF44-csFCur-kEgU8awapJzKnqDKgw";
        rsaKey.e = "AQAB";
        Assert.assertEquals((String)JWTUtils.generateJWS_kid((JSONWebKey)rsaKey), (String)"nMGlFRw9Y5POaSOaIaRBc9P2nfA");
        Assert.assertEquals((String)JWTUtils.generateJWS_kid((String)"SHA-1", (JSONWebKey)rsaKey), (String)"nMGlFRw9Y5POaSOaIaRBc9P2nfA");
        Assert.assertEquals((String)JWTUtils.generateJWS_kid_S256((JSONWebKey)rsaKey), (String)"NzbLsXh8uDCcd-6MNwXF4W_7noWXFZAfHkxZsRGC9Xs");
        Assert.assertEquals((String)JWTUtils.generateJWS_kid((String)"SHA-256", (JSONWebKey)rsaKey), (String)"NzbLsXh8uDCcd-6MNwXF4W_7noWXFZAfHkxZsRGC9Xs");
    }

    @Test
    public void jws_kid_ec() {
        JSONWebKey ecKey = new JSONWebKey();
        ecKey.kty = KeyType.EC;
        ecKey.crv = "P-256";
        ecKey.x = "MKBCTNIcKUSDii11ySs3526iDZ8AiTo7Tu6KPAqv7D4";
        ecKey.y = "4Etl6SRW2YiLUrN5vfvVHuhp7x8PxltmWWlbbM4IFyM";
        Assert.assertEquals((String)JWTUtils.generateJWS_kid((JSONWebKey)ecKey), (String)"VHriznG7vJAFpXMXRmGgAkA5sEE");
        Assert.assertEquals((String)JWTUtils.generateJWS_kid((String)"SHA-1", (JSONWebKey)ecKey), (String)"VHriznG7vJAFpXMXRmGgAkA5sEE");
        Assert.assertEquals((String)JWTUtils.generateJWS_kid_S256((JSONWebKey)ecKey), (String)"cn-I_WNMClehiVp51i_0VpOENW1upEerA8sEam5hn-s");
        Assert.assertEquals((String)JWTUtils.generateJWS_kid((String)"SHA-256", (JSONWebKey)ecKey), (String)"cn-I_WNMClehiVp51i_0VpOENW1upEerA8sEam5hn-s");
    }

    private void assertPrefix(String key, String prefix) {
        Assert.assertTrue((boolean)key.startsWith(prefix));
    }

    private void assertSuffix(String key, String suffix) {
        String trimmed = key.trim();
        Assert.assertTrue((boolean)trimmed.endsWith(suffix));
    }
}

