/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt;

import io.fusionauth.jwt.BaseJWTTest;
import io.fusionauth.jwt.InvalidJWTException;
import io.fusionauth.jwt.InvalidKeyLengthException;
import io.fusionauth.jwt.JWTDecoder;
import io.fusionauth.jwt.JWTExpiredException;
import io.fusionauth.jwt.JWTUnavailableForProcessingException;
import io.fusionauth.jwt.JWTUtils;
import io.fusionauth.jwt.Signer;
import io.fusionauth.jwt.UnsecuredSigner;
import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.jwt.domain.Header;
import io.fusionauth.jwt.domain.JWT;
import io.fusionauth.jwt.ec.ECSigner;
import io.fusionauth.jwt.ec.ECVerifier;
import io.fusionauth.jwt.hmac.HMACSigner;
import io.fusionauth.jwt.hmac.HMACVerifier;
import io.fusionauth.jwt.rsa.RSAPSSSigner;
import io.fusionauth.jwt.rsa.RSAPSSVerifier;
import io.fusionauth.jwt.rsa.RSASigner;
import io.fusionauth.jwt.rsa.RSAVerifier;
import io.fusionauth.pem.domain.PEM;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.PublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.time.Duration;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.Test;

public class JWTTest
extends BaseJWTTest {
    private final String rsaPrivateKey4096Pem = new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_private_key_4096.pem", new String[0])));
    private final Path ecPublicKey256Path = Paths.get("src/test/resources/ec_public_key_p_256.pem", new String[0]);
    private final Path rsaPublicKey4096Path = Paths.get("src/test/resources/rsa_public_key_4096.pem", new String[0]);
    private final Path rsaPublicKey2048Path = Paths.get("src/test/resources/rsa_public_key_2048.pem", new String[0]);
    private final Path secretPath = Paths.get("src/test/resources/secret.txt", new String[0]);

    @Test(enabled=false)
    public void buildSignerPerformance() throws Exception {
        long iterationCount = 500000L;
        String privateKey = new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_private_key_2048.pem", new String[0])));
        Instant start = Instant.now();
        int i = 0;
        while ((long)i < iterationCount) {
            RSASigner.newSHA256Signer((String)privateKey);
            ++i;
        }
        Duration duration = Duration.between(start, Instant.now());
        BigDecimal durationInMillis = BigDecimal.valueOf(duration.toMillis());
        BigDecimal average = durationInMillis.divide(BigDecimal.valueOf(iterationCount), RoundingMode.HALF_DOWN);
        long perSecond = iterationCount / (duration.toMillis() / 1000L);
        System.out.println("[Build Signer] " + duration.toMillis() + " milliseconds total. [" + iterationCount + "] iterations. [" + average + "] milliseconds per iteration. Approx. [" + perSecond + "] per second.");
    }

    @Test(enabled=false)
    public void buildVerifierPerformance() throws Exception {
        long iterationCount = 500000L;
        String publicKey = new String(Files.readAllBytes(this.rsaPublicKey2048Path));
        Instant start = Instant.now();
        int i = 0;
        while ((long)i < iterationCount) {
            RSAVerifier.newVerifier((String)publicKey);
            ++i;
        }
        Duration duration = Duration.between(start, Instant.now());
        BigDecimal durationInMillis = BigDecimal.valueOf(duration.toMillis());
        BigDecimal average = durationInMillis.divide(BigDecimal.valueOf(iterationCount), RoundingMode.HALF_DOWN);
        long perSecond = iterationCount / (duration.toMillis() / 1000L);
        System.out.println("[Build Verifier] " + duration.toMillis() + " milliseconds total. [" + iterationCount + "] iterations. [" + average + "] milliseconds per iteration. Approx. [" + perSecond + "] per second.");
    }

    @Test(enabled=false)
    public void decoding_performance() throws Exception {
        String secret = JWTUtils.generateSHA256_HMACSecret();
        HMACSigner hmacSigner = HMACSigner.newSHA256Signer((String)secret);
        RSASigner rsaSigner = RSASigner.newSHA256Signer((String)new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_private_key_2048.pem", new String[0]))));
        HMACVerifier hmacVerifier = HMACVerifier.newVerifier((String)secret);
        RSAVerifier rsaVerifier = RSAVerifier.newVerifier((String)new String(Files.readAllBytes(this.rsaPublicKey2048Path)));
        JWT jwt = new JWT().setSubject(UUID.randomUUID().toString()).addClaim("exp", (Object)ZonedDateTime.now(ZoneOffset.UTC).plusMinutes(5L).toInstant().toEpochMilli()).setAudience((Object)UUID.randomUUID().toString()).addClaim("roles", new ArrayList<String>(Arrays.asList("admin", "user"))).addClaim("iat", (Object)ZonedDateTime.now(ZoneOffset.UTC).toInstant().toEpochMilli()).setIssuer("inversoft.com");
        long iterationCount = 250000L;
        for (Verifier verifier : Arrays.asList(hmacVerifier, rsaVerifier)) {
            Instant start = Instant.now();
            HMACSigner signer = verifier instanceof HMACVerifier ? hmacSigner : rsaSigner;
            String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer);
            int i = 0;
            while ((long)i < iterationCount) {
                JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
                ++i;
            }
            Duration duration = Duration.between(start, Instant.now());
            BigDecimal durationInMillis = BigDecimal.valueOf(duration.toMillis());
            BigDecimal average = durationInMillis.divide(BigDecimal.valueOf(iterationCount), RoundingMode.HALF_DOWN);
            long perSecond = iterationCount / (duration.toMillis() / 1000L);
            System.out.println("[" + signer.getAlgorithm().name() + "] " + duration.toMillis() + " milliseconds total. [" + iterationCount + "] iterations. [" + average + "] milliseconds per iteration. Approx. [" + perSecond + "] per second.");
        }
    }

    @Test(enabled=false)
    public void encoding_performance() throws Exception {
        HMACSigner hmacSigner = HMACSigner.newSHA256Signer((String)JWTUtils.generateSHA256_HMACSecret());
        RSASigner rsaSigner = RSASigner.newSHA256Signer((String)new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_private_key_2048.pem", new String[0]))));
        JWT jwt = new JWT().setSubject(UUID.randomUUID().toString()).addClaim("exp", (Object)ZonedDateTime.now(ZoneOffset.UTC).plusMinutes(5L).toInstant().toEpochMilli()).setAudience((Object)UUID.randomUUID().toString()).addClaim("roles", new ArrayList<String>(Arrays.asList("admin", "user"))).addClaim("iat", (Object)ZonedDateTime.now(ZoneOffset.UTC).toInstant().toEpochMilli()).setIssuer("inversoft.com");
        long iterationCount = 10000L;
        for (Signer signer : Arrays.asList(hmacSigner, rsaSigner)) {
            Instant start = Instant.now();
            int i = 0;
            while ((long)i < iterationCount) {
                JWT.getEncoder().encode(jwt, signer);
                ++i;
            }
            Duration duration = Duration.between(start, Instant.now());
            BigDecimal durationInMillis = BigDecimal.valueOf(duration.toMillis());
            BigDecimal average = durationInMillis.divide(BigDecimal.valueOf(iterationCount), RoundingMode.HALF_DOWN);
            long perSecond = iterationCount / (duration.toMillis() / 1000L);
            System.out.println("[" + signer.getAlgorithm().getName() + "] " + duration.toMillis() + " milliseconds total. [" + iterationCount + "] iterations. [" + average + "] milliseconds per iteration. Approx. [" + perSecond + "] per second.");
        }
    }

    @Test
    public void expired() {
        Assert.assertFalse((boolean)new JWT().setSubject("123456789").isExpired());
        Assert.assertFalse((boolean)new JWT().setExpiration(ZonedDateTime.now(ZoneOffset.UTC).plusMinutes(1L)).setSubject("123456789").isExpired());
        Assert.assertTrue((boolean)new JWT().setExpiration(ZonedDateTime.now(ZoneOffset.UTC).minusMinutes(1L)).setSubject("123456789").isExpired());
        Assert.assertTrue((boolean)new JWT().setExpiration(ZonedDateTime.now(ZoneOffset.UTC).minusMinutes(1L)).setSubject("123456789").isExpired(ZonedDateTime.now(ZoneOffset.UTC).minusSeconds(59L)));
        Assert.assertFalse((boolean)new JWT().setExpiration(ZonedDateTime.now(ZoneOffset.UTC).minusMinutes(1L)).setSubject("123456789").isExpired(ZonedDateTime.now(ZoneOffset.UTC).minusSeconds(61L)));
    }

    @Test
    public void test_EC_privateKey_needsConversionTo_pkcs_8() {
        JWT jwt = new JWT().setSubject("1234567890").addClaim("name", (Object)"John Doe").addClaim("admin", (Object)true).addClaim("iat", (Object)1516239022);
        ECSigner signer = ECSigner.newSHA512Signer((String)"-----BEGIN EC PRIVATE KEY-----\nMIHcAgEBBEIBiyAa7aRHFDCh2qga9sTUGINE5jHAFnmM8xWeT/uni5I4tNqhV5Xx\n0pDrmCV9mbroFtfEa0XVfKuMAxxfZ6LM/yKgBwYFK4EEACOhgYkDgYYABAGBzgdn\nP798FsLuWYTDDQA7c0r3BVk8NnRUSexpQUsRilPNv3SchO0lRw9Ru86x1khnVDx+\nduq4BiDFcvlSAcyjLACJvjvoyTLJiA+TQFdmrearjMiZNE25pT2yWP1NUndJxPcv\nVtfBW48kPOmvkY4WlqP5bAwCXwbsKrCgk6xbsp12ew==\n-----END EC PRIVATE KEY-----");
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer, header -> header.set("kid", (Object)"xZDfZpry4P9vZPZyG2fNBRj-7Lz5omVdm7tHoCgSNfY"));
        ECVerifier verifier = ECVerifier.newVerifier((String)"-----BEGIN PUBLIC KEY-----\nMIGbMBAGByqGSM49AgEGBSuBBAAjA4GGAAQBgc4HZz+/fBbC7lmEww0AO3NK9wVZ\nPDZ0VEnsaUFLEYpTzb90nITtJUcPUbvOsdZIZ1Q8fnbquAYgxXL5UgHMoywAib47\n6MkyyYgPk0BXZq3mq4zImTRNuaU9slj9TVJ3ScT3L1bXwVuPJDzpr5GOFpaj+WwM\nAl8G7CqwoJOsW7Kddns=\n-----END PUBLIC KEY-----");
        JWT actual = JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((String)actual.subject, (String)jwt.subject);
    }

    @Test
    public void test_ES() throws IOException {
        ECSigner signer = ECSigner.newSHA256Signer((String)new String(Files.readAllBytes(Paths.get("src/test/resources/ec_private_key_control.pem", new String[0]))));
        ECVerifier verifier = ECVerifier.newVerifier((String)new String(Files.readAllBytes(Paths.get("src/test/resources/ec_public_key_p_256_control.pem", new String[0]))));
        JWT jwt = new JWT().setSubject("123456789");
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer);
        JWT decoded = JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertNotNull((Object)decoded);
        Assert.assertEquals((String)decoded.subject, (String)"123456789");
    }

    @Test
    public void test_ES256() {
        String encodedJWT = "eyJhbGciOiJFUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.vPn7xrCNOLWbBRaWdVn53ddj2hW0E87FYl4gPnWy5d1Qj3WgyF8FS6I_hj_3kIJ77tbvy0GXdr7fO91NeWMD1A";
        ECVerifier verifier = ECVerifier.newVerifier((Path)this.ecPublicKey256Path);
        JWT jwt = JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((String)jwt.subject, (String)"123456789");
        Assert.assertEquals((Object)jwt.header.algorithm, (Object)Algorithm.ES256);
        Assert.assertEquals((String)jwt.header.type, (String)"JWT");
        Assert.assertEquals((String)JWT.getDecoder().decode((String)encodedJWT, (Verifier[])new Verifier[]{ECVerifier.newVerifier((PublicKey)((ECPublicKey)PEM.decode((Path)this.ecPublicKey256Path).getPublicKey()))}).subject, (String)"123456789");
    }

    @Test
    public void test_ES256_control() {
        String encodedJWT = "eyJhbGciOiJFUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWUsImlhdCI6MTUxNjIzOTAyMn0.tyh-VfuzIxCyGYDlkBA7DfyjrqmSHu6pQ2hoZuFqUSLPNY2N0mpHb3nk5K17HWP_3cYHBw7AhHale5wky6-sVA";
        JWT jwt = JWT.getDecoder().decode(encodedJWT, new Verifier[]{ECVerifier.newVerifier((String)"-----BEGIN PUBLIC KEY-----\nMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEEVs/o5+uQbTjL3chynL4wXgUg2R9\nq9UU8I5mEovUf86QZ7kOBIjJwqnzD1omageEHWwHdBO6B+dFabmdT9POxg==\n-----END PUBLIC KEY-----")});
        Assert.assertNotNull((Object)jwt);
        Assert.assertEquals((String)jwt.subject, (String)"1234567890");
        Assert.assertEquals((String)jwt.getString("name"), (String)"John Doe");
        Assert.assertEquals((Boolean)jwt.getBoolean("admin"), (Boolean)Boolean.TRUE);
        Assert.assertEquals(jwt.getRawClaims().get("iat"), (Object)1516239022L);
        Assert.assertEquals((Object)jwt.issuedAt, (Object)ZonedDateTime.ofInstant(Instant.ofEpochSecond(1516239022L), ZoneOffset.UTC));
    }

    @Test
    public void test_ES384() throws Exception {
        String encodedJWT = "eyJhbGciOiJFUzM4NCIsInR5cCI6IkpXVCIsImtpZCI6ImlUcVhYSTB6YkFuSkNLRGFvYmZoa00xZi02ck1TcFRmeVpNUnBfMnRLSTgifQ.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWUsImlhdCI6MTUxNjIzOTAyMn0.cJOP_w-hBqnyTsBm3T6lOE5WpcHaAkLuQGAs1QO-lg2eWs8yyGW8p9WagGjxgvx7h9X72H7pXmXqej3GdlVbFmhuzj45A9SXDOAHZ7bJXwM1VidcPi7ZcrsMSCtP1hiN";
        ECVerifier verifier = ECVerifier.newVerifier((String)new String(Files.readAllBytes(Paths.get("src/test/resources/ec_public_key_p_384_2.pem", new String[0]))));
        JWT jwt = JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((String)jwt.subject, (String)"1234567890");
        Assert.assertEquals((String)jwt.getString("name"), (String)"John Doe");
        Assert.assertEquals((Boolean)jwt.getBoolean("admin"), (Boolean)Boolean.TRUE);
        Assert.assertEquals(jwt.getRawClaims().get("iat"), (Object)1516239022L);
    }

    @Test
    public void test_ES384_control() {
        String encodedJWT = "eyJhbGciOiJFUzM4NCIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWUsImlhdCI6MTUxNjIzOTAyMn0.okIXzSvlJ0gFtnrrcdlzcnYBiJsk-S5m4Qj-qpUSgnT6uMrYIYL06Z7_Nx6buKFyY4DgeS8RU-9tZOy1VmayTbvm0hQyjuiDY8tsoVHi7FhhF4GyTDAAgDH_4jK_h4_R";
        JWT jwt = JWT.getDecoder().decode(encodedJWT, new Verifier[]{ECVerifier.newVerifier((String)"-----BEGIN PUBLIC KEY-----\nMHYwEAYHKoZIzj0CAQYFK4EEACIDYgAEC1uWSXj2czCDwMTLWV5BFmwxdM6PX9p+\nPk9Yf9rIf374m5XP1U8q79dBhLSIuaojsvOT39UUcPJROSD1FqYLued0rXiooIii\n1D3jaW6pmGVJFhodzC31cy5sfOYotrzF\n-----END PUBLIC KEY-----")});
        Assert.assertNotNull((Object)jwt);
        Assert.assertEquals((String)jwt.subject, (String)"1234567890");
        Assert.assertEquals((String)jwt.getString("name"), (String)"John Doe");
        Assert.assertEquals((Boolean)jwt.getBoolean("admin"), (Boolean)Boolean.TRUE);
        Assert.assertEquals(jwt.getRawClaims().get("iat"), (Object)1516239022L);
        Assert.assertEquals((Object)jwt.issuedAt, (Object)ZonedDateTime.ofInstant(Instant.ofEpochSecond(1516239022L), ZoneOffset.UTC));
    }

    @Test
    public void test_ES512() throws Exception {
        String encodedJWT = "eyJhbGciOiJFUzUxMiIsInR5cCI6IkpXVCIsImtpZCI6InhaRGZacHJ5NFA5dlpQWnlHMmZOQlJqLTdMejVvbVZkbTd0SG9DZ1NOZlkifQ.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWUsImlhdCI6MTUxNjIzOTAyMn0.AP_CIMClixc5-BFflmjyh_bRrkloEvwzn8IaWJFfMz13X76PGWF0XFuhjJUjp7EYnSAgtjJ-7iJG4IP7w3zGTBk_AUdmvRCiWp5YAe8S_Hcs8e3gkeYoOxiXFZlSSAx0GfwW1cZ0r67mwGtso1I3VXGkSjH5J0Rk6809bn25GoGRjOPu";
        ECVerifier verifier = ECVerifier.newVerifier((String)new String(Files.readAllBytes(Paths.get("src/test/resources/ec_public_key_p_521_2.pem", new String[0]))));
        JWT jwt = JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((String)jwt.subject, (String)"1234567890");
        Assert.assertEquals((String)jwt.getString("name"), (String)"John Doe");
        Assert.assertEquals((Boolean)jwt.getBoolean("admin"), (Boolean)Boolean.TRUE);
        Assert.assertEquals(jwt.getRawClaims().get("iat"), (Object)1516239022L);
    }

    @Test
    public void test_ES512_control() {
        String encodedJWT = "eyJhbGciOiJFUzUxMiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkwIiwibmFtZSI6IkpvaG4gRG9lIiwiYWRtaW4iOnRydWUsImlhdCI6MTUxNjIzOTAyMn0.AU5vXkGbPjUABWey3dk4_UldeQMXMwjHY6LG6ff5J-YzH925b4ItQzkJ0kuOuwammUTXRZ7_4W76qa-ooR0umLl1AU0YjFVqxBFXeletCYCznFnIlZYJS-iKqvuwpwPFT0b4OHQxmrIV0ETw4Ei2p1dDMtX4oAbBi-DRybc70CA5f3XT";
        JWT jwt = JWT.getDecoder().decode(encodedJWT, new Verifier[]{ECVerifier.newVerifier((String)"-----BEGIN PUBLIC KEY-----\nMIGbMBAGByqGSM49AgEGBSuBBAAjA4GGAAQBgc4HZz+/fBbC7lmEww0AO3NK9wVZ\nPDZ0VEnsaUFLEYpTzb90nITtJUcPUbvOsdZIZ1Q8fnbquAYgxXL5UgHMoywAib47\n6MkyyYgPk0BXZq3mq4zImTRNuaU9slj9TVJ3ScT3L1bXwVuPJDzpr5GOFpaj+WwM\nAl8G7CqwoJOsW7Kddns=\n-----END PUBLIC KEY-----")});
        Assert.assertNotNull((Object)jwt);
        Assert.assertEquals((String)jwt.subject, (String)"1234567890");
        Assert.assertEquals((String)jwt.getString("name"), (String)"John Doe");
        Assert.assertEquals((Boolean)jwt.getBoolean("admin"), (Boolean)Boolean.TRUE);
        Assert.assertEquals(jwt.getRawClaims().get("iat"), (Object)1516239022L);
        Assert.assertEquals((Object)jwt.issuedAt, (Object)ZonedDateTime.ofInstant(Instant.ofEpochSecond(1516239022L), ZoneOffset.UTC));
    }

    @Test
    public void test_ES_2() throws IOException {
        ECSigner signer = ECSigner.newSHA256Signer((String)new String(Files.readAllBytes(Paths.get("src/test/resources/ec_private_key_p_256.pem", new String[0]))));
        ECVerifier verifier = ECVerifier.newVerifier((String)new String(Files.readAllBytes(this.ecPublicKey256Path)));
        JWT jwt = new JWT().setSubject("123456789");
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer);
        JWT decoded = JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertNotNull((Object)decoded);
        Assert.assertEquals((String)decoded.subject, (String)"123456789");
    }

    @Test
    public void test_HS256() {
        JWT jwt = new JWT().setSubject("123456789");
        HMACSigner signer = HMACSigner.newSHA256Signer((String)"secret");
        Assert.assertEquals((String)JWT.getEncoder().encode(jwt, (Signer)signer), (String)"eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.qHdut1UR4-2FSAvh7U3YdeRR5r5boVqjIGQ16Ztp894");
        signer = HMACSigner.newSHA256Signer((byte[])"secret".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((String)JWT.getEncoder().encode(jwt, (Signer)signer), (String)"eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.qHdut1UR4-2FSAvh7U3YdeRR5r5boVqjIGQ16Ztp894");
    }

    @Test
    public void test_HS256_manualAddedClaim() {
        JWT jwt = new JWT().addClaim("test", (Object)"123456789");
        HMACSigner signer = HMACSigner.newSHA256Signer((String)"secret");
        Assert.assertEquals((String)JWT.getEncoder().encode(jwt, (Signer)signer), (String)"eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJ0ZXN0IjoiMTIzNDU2Nzg5In0.0qgr4ztqB0mNXA8mtqaBSL6UJT3aqEyjHMrWDZmT4Bc");
    }

    @Test
    public void test_HS384() {
        JWT jwt = new JWT().setSubject("123456789");
        HMACSigner signer = HMACSigner.newSHA384Signer((String)"secret");
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer);
        Assert.assertEquals((String)encodedJWT, (String)"eyJhbGciOiJIUzM4NCIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.sCHKynlQkBveA063_Z-fwcXmRYp_lKQ0fRqGNzplb14qMUj5CV3CfXwluclTF17P");
        Assert.assertEquals((String)JWT.getDecoder().decode((String)encodedJWT, (Verifier[])new Verifier[]{HMACVerifier.newVerifier((String)"secret")}).subject, (String)jwt.subject);
        signer = HMACSigner.newSHA384Signer((byte[])"secret".getBytes(StandardCharsets.UTF_8));
        encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer);
        Assert.assertEquals((String)encodedJWT, (String)"eyJhbGciOiJIUzM4NCIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.sCHKynlQkBveA063_Z-fwcXmRYp_lKQ0fRqGNzplb14qMUj5CV3CfXwluclTF17P");
        Assert.assertEquals((String)JWT.getDecoder().decode((String)encodedJWT, (Verifier[])new Verifier[]{HMACVerifier.newVerifier((String)"secret")}).subject, (String)jwt.subject);
        Assert.assertEquals((String)JWT.getDecoder().decode((String)encodedJWT, (Verifier[])new Verifier[]{HMACVerifier.newVerifier((byte[])"secret".getBytes((Charset)StandardCharsets.UTF_8))}).subject, (String)jwt.subject);
    }

    @Test
    public void test_HS512() {
        JWT jwt = new JWT().setSubject("123456789");
        HMACSigner signer = HMACSigner.newSHA512Signer((String)"secret");
        Assert.assertEquals((String)JWT.getEncoder().encode(jwt, (Signer)signer), (String)"eyJhbGciOiJIUzUxMiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.MgAi9gfGkep-IoFYPHMhHz6w2Kxf0u8TZ-wNeQOLPwc8emLNKOMqBU-5dJXeaY5-8wQ1CvZycWHbEilvHgN6Ug");
        signer = HMACSigner.newSHA512Signer((byte[])"secret".getBytes(StandardCharsets.UTF_8));
        Assert.assertEquals((String)JWT.getEncoder().encode(jwt, (Signer)signer), (String)"eyJhbGciOiJIUzUxMiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.MgAi9gfGkep-IoFYPHMhHz6w2Kxf0u8TZ-wNeQOLPwc8emLNKOMqBU-5dJXeaY5-8wQ1CvZycWHbEilvHgN6Ug");
    }

    @Test
    public void test_RS256() {
        JWT jwt = new JWT().setSubject("123456789");
        RSASigner signer = RSASigner.newSHA256Signer((String)this.rsaPrivateKey4096Pem);
        Assert.assertEquals((String)JWT.getEncoder().encode(jwt, (Signer)signer), (String)"eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.kRXJkOHC98D0LCT2oPg5fTmQJDFXkMRQJopbt7QM6prmQDHwjJL_xO-_EXRXnbvf5NLORto45By3XNn2ZzWmY3pAOxj46MlQ5elhROx2S-EnHZNLfQhoG8ZXPZ54q-Obz_6K7ZSlkAQ8jmeZUO3Ryi8jRlHQ2PT4LbBtLpaf982SGJfeTyUMw1LbvowZUTZSF-E6JARaokmmx8M2GeLuKcFhU-YsBTXUarKp0IJCy3jpMQ2zW_HGjyVWH8WwSIbSdpBn7ztoQEJYO-R5H3qVaAz2BsTuGLRxoyIu1iy2-QcDp5uTufmX1roXM8ciQMpcfwKGiyNpKVIZm-lF8aROXRL4kk4rqp6KUzJuOPljPXRU--xKSua-DeR0BEerKzI9hbwIMWiblCslAciNminoSc9G7pUyVwV5Z5IT8CGJkVgoyVGELeBmYCDy7LHwXrr0poc0hPbE3mJXhzolga4BB84nCg2Hb9tCNiHU8F-rKgZWCONaSSIdhQ49x8OiPafFh2DJBEBe5Xbm6xdCfh3KVG0qe4XL18R5s98aIP9UIC4i62UEgPy6W7Fr7QgUxpXrjRCERBV3MiNu4L8NNJb3oZleq5lQi72EfdS-Bt8ZUOVInIcAvSmu-3i8jB_2sF38XUXdl8gkW8k_b9dJkzDcivCFehvSqGmm3vBm5X4bNmk");
    }

    @Test
    public void test_PS256() throws IOException {
        JWT jwt = new JWT().setSubject("1234567890");
        RSAPSSSigner signer = RSAPSSSigner.newSHA256Signer((String)new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_private_key_2048.pem", new String[0]))));
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer);
        RSAPSSVerifier verifier = RSAPSSVerifier.newVerifier((Path)this.rsaPublicKey2048Path);
        JWT actual = JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((String)actual.subject, (String)jwt.subject);
    }

    @Test
    public void test_PS384() throws IOException {
        JWT jwt = new JWT().setSubject("1234567890");
        RSAPSSSigner signer = RSAPSSSigner.newSHA384Signer((String)new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_private_key_2048.pem", new String[0]))));
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer);
        RSAPSSVerifier verifier = RSAPSSVerifier.newVerifier((Path)this.rsaPublicKey2048Path);
        JWT actual = JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((String)actual.subject, (String)jwt.subject);
    }

    @Test
    public void test_PS512() throws IOException {
        JWT jwt = new JWT().setSubject("1234567890");
        RSAPSSSigner signer = RSAPSSSigner.newSHA512Signer((String)new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_private_key_3072.pem", new String[0]))));
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer);
        RSAPSSVerifier verifier = RSAPSSVerifier.newVerifier((Path)Paths.get("src/test/resources/rsa_public_key_3072.pem", new String[0]));
        JWT actual = JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((String)actual.subject, (String)jwt.subject);
    }

    @Test
    public void test_RS384() throws Exception {
        JWT jwt = new JWT().setSubject("123456789");
        RSASigner signer = RSASigner.newSHA384Signer((String)this.rsaPrivateKey4096Pem);
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer);
        Assert.assertEquals((String)encodedJWT, (String)"eyJhbGciOiJSUzM4NCIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.OkmWXzhTm7mtfpeMVNLlFjw3fJvc7yMQ1rgI5BXBPqaLSb_fpLHYAq_q5pQDDaIGg8klg9y2f784smc7-o9czX3JnzEDvO9e_sA10YIEA6Q9qRh17EATNXFG-WzSocpxPgEOQZ8lqSqZ_0waCGaUMwK5J5BB1A_70AcNGPnI7PrX76lWNNHwdK0OjkhkxX7vHR6B-uAIzih0ntQP_afr1UIzXkllmnnb1oU9cgFFD1AGDa3V0XCgitVYZA_ozbGELGMrUl_7fB_uNVEvcreUoZIEI4cfUKI6iZ8Ll4j_iLAdlpH4GRGNiQ7gMLq35AqqxKbEG8r-S-SrlRL6PkKlaJ-viMVLxoHreZow634r8A1fxR1mnrdUnn0vGmOthyjpP_TgfAsER9EJ_UUIamsKC8s6pip2jcPB7G6huHocyKBTxsoxclQgk1jOy4lZq4Js2KKM5sGfcq5SWQTW4B44KlUU1kWWmUg21jtflna38sWFdTk845phi5ITOBZ_ElJ9MdYVAgjvDsRFs_XxFENlwpwKeLD9PsaCiJhdG7EJN5qJvVogYuUMM0wyS-SOGZ1ILsTeYsjc7TtI0JUKndlUXFPubwaaxW_06zrCJR-dvWye99fIDH-u3I74XK5MKhknlgewzsXpsiPdvsMW59WUbdIZqkvok5vdkIlm4XGIqcM");
        Assert.assertEquals((String)JWT.getDecoder().decode((String)encodedJWT, (Verifier[])new Verifier[]{RSAVerifier.newVerifier((String)new String((byte[])Files.readAllBytes((Path)this.rsaPublicKey4096Path)))}).subject, (String)jwt.subject);
        Assert.assertEquals((String)JWT.getDecoder().decode((String)encodedJWT, (Verifier[])new Verifier[]{RSAVerifier.newVerifier((PublicKey)((RSAPublicKey)PEM.decode((Path)this.rsaPublicKey4096Path).getPublicKey()))}).subject, (String)jwt.subject);
    }

    @Test
    public void test_RS512() {
        JWT jwt = new JWT().setSubject("123456789");
        RSASigner signer = RSASigner.newSHA512Signer((String)this.rsaPrivateKey4096Pem);
        Assert.assertEquals((String)JWT.getEncoder().encode(jwt, (Signer)signer), (String)"eyJhbGciOiJSUzUxMiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiIxMjM0NTY3ODkifQ.ei28WNoJdUpMlLnHr78HiTnnuKwSRLYcOpgUC3daVInT5RAc0kk2Ipx16Z-bHL_eFLSYgF3TSKdymFpNf8cnEu5T6rH0azYSZLrPmVCetDxjo-ixXK9asPOF3JuIbDjN7ow3K-CMbMCWzWp04ZAh-DNecYEd3HiGgooPVGA4HuVXZFHH8XfQ9TD-64ppBQTWgW32vkna8ILKyIXdwWXSEfCZYfLzLZnilJrz820wZJ5JMXimv2au0OwwRobUMLEBUM4iuEPXLf5wFJU6LcU0XMuovavfIXKDpvP9Yfz6UplMlFvIr9y72xExfaNt32vwneAP-Fpg2x9wYvR0W8LhXKZaFRfcYwhbj17GCAbpx34hjiqnwyFStn5Qx_QHz_Y7ck-ZXB2MGUkiYGj9y_8bQNx-LIaTQUX6sONTNdVVCfnOnMHFqVbupGho24K7885-8BxCRojvA0ggneF6dsKCQvAt2rsVRso0TrCVxwYItb9tRsyhCbWou-zh_08JlYGVXPiGY3RRQDfxCc9RHQUflWRS9CBcPtoaco4mFKZSM-9e_xoYx__DEzM3UjaI4jReLM-IARwlVPoHJa2Vcb5wngZTaxGf2ToMq7R_8KecZymb3OaA2X1e8GS2300ySwsXbOz0sJv2a7_JUncSEBPSsb2vMMurxSJ4E3RTAc4s3aU");
    }

    @Test
    public void test_RSA_1024Key() {
        this.expectException(InvalidKeyLengthException.class, () -> RSASigner.newSHA256Signer((String)new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_private_key_1024.pem", new String[0])))));
        this.expectException(InvalidKeyLengthException.class, () -> RSAVerifier.newVerifier((String)new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_public_key_1024.pem", new String[0])))));
        this.expectException(InvalidKeyLengthException.class, () -> RSAVerifier.newVerifier((PublicKey)((RSAPublicKey)PEM.decode((byte[])Files.readAllBytes(Paths.get("src/test/resources/rsa_public_key_1024.pem", new String[0]))).getPublicKey())));
    }

    @Test
    public void test_badEncoding() throws Exception {
        RSAVerifier verifier = RSAVerifier.newVerifier((String)new String(Files.readAllBytes(this.rsaPublicKey2048Path)));
        this.expectException(InvalidJWTException.class, () -> JWTTest.lambda$test_badEncoding$4((Verifier)verifier));
    }

    @Test
    public void test_complexPayload() {
        JWT expectedJWT = new JWT().setAudience(Arrays.asList("www.acme.com", "www.vandelayindustries.com")).setExpiration(ZonedDateTime.now(ZoneOffset.UTC).plusMinutes(60L).truncatedTo(ChronoUnit.SECONDS)).setIssuedAt(ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS)).setIssuer("www.inversoft.com").setNotBefore(ZonedDateTime.now(ZoneOffset.UTC).minusMinutes(5L).truncatedTo(ChronoUnit.SECONDS)).setUniqueId(UUID.randomUUID().toString()).setSubject("123456789").addClaim("foo", (Object)"bar").addClaim("timestamp", (Object)1476062602926L).addClaim("bigInteger", (Object)new BigInteger("100000000000000000000000000000000000000000000000000000000000000000000000000000000")).addClaim("bigDecimal", (Object)new BigDecimal("11.2398732934908570987534209857423098743209857")).addClaim("double", (Object)3.14).addClaim("float", (Object)Float.valueOf(3.14f)).addClaim("meaningOfLife", (Object)42).addClaim("bar", Arrays.asList("bing", "bam", "boo")).addClaim("object", Collections.singletonMap("nested", Collections.singletonMap("foo", "bar"))).addClaim("www.inversoft.com/claims/is_admin", (Object)true);
        HMACSigner signer = HMACSigner.newSHA256Signer((String)"secret");
        HMACVerifier verifier = HMACVerifier.newVerifier((String)"secret");
        String encodedJWT = JWT.getEncoder().encode(expectedJWT, (Signer)signer, () -> new Header().set("gty", Collections.singletonList("client_credentials")).set("kid", (Object)"1234"));
        JWT actualJwt = JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((Object)actualJwt.header.algorithm, (Object)Algorithm.HS256);
        Assert.assertEquals((String)actualJwt.header.type, (String)"JWT");
        Assert.assertEquals((Object)actualJwt.header.get("gty"), Collections.singletonList("client_credentials"));
        Assert.assertEquals((Object)actualJwt.getHeaderClaim("gty"), Collections.singletonList("client_credentials"));
        Assert.assertEquals((Object)actualJwt.header.get("kid"), (Object)"1234");
        Assert.assertEquals((Object)actualJwt.getHeaderClaim("kid"), (Object)"1234");
        Assert.assertNull((Object)actualJwt.header.get("foo"));
        Assert.assertNull((Object)actualJwt.getHeaderClaim("foo"));
        Assert.assertEquals((Object)actualJwt.audience, (Object)expectedJWT.audience);
        Assert.assertEquals((Object)actualJwt.expiration, (Object)expectedJWT.expiration);
        Assert.assertEquals((Object)actualJwt.issuedAt, (Object)expectedJWT.issuedAt);
        Assert.assertEquals((String)actualJwt.issuer, (String)expectedJWT.issuer);
        Assert.assertEquals((Object)actualJwt.notBefore, (Object)expectedJWT.notBefore);
        Assert.assertEquals((String)actualJwt.uniqueId, (String)expectedJWT.uniqueId);
        Assert.assertEquals((String)actualJwt.subject, (String)expectedJWT.subject);
        Assert.assertEquals((String)actualJwt.getString("foo"), (String)expectedJWT.getString("foo"));
        Assert.assertEquals((Object)actualJwt.getBigInteger("timestamp"), (Object)expectedJWT.getBigInteger("timestamp"));
        Assert.assertEquals((Long)actualJwt.getLong("timestamp"), (Long)expectedJWT.getLong("timestamp"));
        Assert.assertEquals((Object)actualJwt.getNumber("timestamp"), (Object)expectedJWT.getNumber("timestamp"));
        Assert.assertEquals((Object)actualJwt.getBigInteger("meaningOfLife"), (Object)expectedJWT.getBigInteger("meaningOfLife"));
        Assert.assertEquals((Integer)actualJwt.getInteger("meaningOfLife"), (Integer)expectedJWT.getInteger("meaningOfLife"));
        Assert.assertEquals((Object)actualJwt.getNumber("meaningOfLife"), (Object)expectedJWT.getNumber("meaningOfLife"));
        Assert.assertEquals((Object)actualJwt.getBigDecimal("double"), (Object)expectedJWT.getBigDecimal("double"));
        Assert.assertEquals((Double)actualJwt.getDouble("double"), (Double)expectedJWT.getDouble("double"));
        Assert.assertEquals((Object)actualJwt.getNumber("double"), (Object)expectedJWT.getNumber("double"));
        Assert.assertEquals((Object)actualJwt.getBigDecimal("float"), (Object)expectedJWT.getBigDecimal("float"));
        Assert.assertEquals((Float)actualJwt.getFloat("float"), (Float)expectedJWT.getFloat("float"));
        Assert.assertEquals((Object)actualJwt.getNumber("float"), (Object)expectedJWT.getNumber("float"));
        Assert.assertEquals((Object)actualJwt.getBigInteger("bigInteger"), (Object)expectedJWT.getBigInteger("bigInteger"));
        Assert.assertEquals((Object)actualJwt.getNumber("bigInteger"), (Object)expectedJWT.getNumber("bigInteger"));
        Assert.assertEquals((Object)actualJwt.getBigDecimal("bigDecimal"), (Object)expectedJWT.getBigDecimal("bigDecimal"));
        Assert.assertEquals((Object)actualJwt.getNumber("bigDecimal"), (Object)expectedJWT.getNumber("bigDecimal"));
        Assert.assertEquals((Object)actualJwt.getObject("bar"), (Object)expectedJWT.getObject("bar"));
        Assert.assertEquals((Collection)actualJwt.getList("bar"), (Collection)expectedJWT.getList("bar"));
        Assert.assertEquals((Object)actualJwt.getMap("object"), (Object)expectedJWT.getObject("object"));
        Assert.assertEquals((Boolean)actualJwt.getBoolean("www.inversoft.com/claims/is_admin"), (Boolean)expectedJWT.getBoolean("www.inversoft.com/claims/is_admin"));
        Map rawClaims = actualJwt.getRawClaims();
        Assert.assertEquals(rawClaims.get("aud"), (Object)expectedJWT.audience);
        Assert.assertEquals(rawClaims.get("exp"), (Object)expectedJWT.expiration.toEpochSecond());
        Assert.assertEquals(rawClaims.get("iat"), (Object)expectedJWT.issuedAt.toEpochSecond());
        Assert.assertEquals(rawClaims.get("iss"), (Object)expectedJWT.issuer);
        Assert.assertEquals(rawClaims.get("nbf"), (Object)expectedJWT.notBefore.toEpochSecond());
        Assert.assertEquals(rawClaims.get("jti"), (Object)expectedJWT.uniqueId);
        Assert.assertEquals(rawClaims.get("sub"), (Object)expectedJWT.subject);
        Assert.assertEquals(rawClaims.get("foo"), (Object)expectedJWT.getString("foo"));
        Assert.assertEquals(rawClaims.get("timestamp"), (Object)expectedJWT.getBigInteger("timestamp"));
        Assert.assertEquals(rawClaims.get("meaningOfLife"), (Object)expectedJWT.getBigInteger("meaningOfLife"));
        Assert.assertEquals(rawClaims.get("bar"), (Object)expectedJWT.getObject("bar"));
        Assert.assertEquals(rawClaims.get("object"), (Object)expectedJWT.getObject("object"));
        Assert.assertEquals(rawClaims.get("www.inversoft.com/claims/is_admin"), (Object)expectedJWT.getBoolean("www.inversoft.com/claims/is_admin"));
        Map allClaims = actualJwt.getAllClaims();
        Assert.assertEquals(allClaims.get("aud"), (Object)expectedJWT.audience);
        Assert.assertEquals(allClaims.get("exp"), (Object)expectedJWT.expiration);
        Assert.assertEquals(allClaims.get("iat"), (Object)expectedJWT.issuedAt);
        Assert.assertEquals(allClaims.get("iss"), (Object)expectedJWT.issuer);
        Assert.assertEquals(allClaims.get("nbf"), (Object)expectedJWT.notBefore);
        Assert.assertEquals(allClaims.get("jti"), (Object)expectedJWT.uniqueId);
        Assert.assertEquals(allClaims.get("sub"), (Object)expectedJWT.subject);
        Assert.assertEquals(allClaims.get("foo"), (Object)expectedJWT.getString("foo"));
        Assert.assertEquals(allClaims.get("timestamp"), (Object)expectedJWT.getBigInteger("timestamp"));
        Assert.assertEquals(allClaims.get("meaningOfLife"), (Object)expectedJWT.getBigInteger("meaningOfLife"));
        Assert.assertEquals(allClaims.get("bar"), (Object)expectedJWT.getObject("bar"));
        Assert.assertEquals(allClaims.get("object"), (Object)expectedJWT.getObject("object"));
        Assert.assertEquals(allClaims.get("www.inversoft.com/claims/is_admin"), (Object)expectedJWT.getBoolean("www.inversoft.com/claims/is_admin"));
    }

    @Test
    public void test_expiredThrows() {
        JWT expectedJWT = new JWT().setExpiration(ZonedDateTime.now(ZoneOffset.UTC).minusMinutes(1L).truncatedTo(ChronoUnit.SECONDS));
        HMACSigner signer = HMACSigner.newSHA256Signer((String)"secret");
        HMACVerifier verifier = HMACVerifier.newVerifier((String)"secret");
        String encodedJWT = JWT.getEncoder().encode(expectedJWT, (Signer)signer);
        this.expectException(JWTExpiredException.class, () -> JWTTest.lambda$test_expiredThrows$6(encodedJWT, (Verifier)verifier));
    }

    @Test
    public void test_notBefore_clockSkew() {
        JWT expectedJWT = new JWT().setSubject("1234567890").setNotBefore(ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(60L).truncatedTo(ChronoUnit.SECONDS)).setExpiration(ZonedDateTime.now(ZoneOffset.UTC).plusMinutes(5L).truncatedTo(ChronoUnit.SECONDS));
        HMACSigner signer = HMACSigner.newSHA256Signer((String)"secret");
        HMACVerifier verifier = HMACVerifier.newVerifier((String)"secret");
        String encodedJWT = JWT.getEncoder().encode(expectedJWT, (Signer)signer);
        this.expectException(JWTUnavailableForProcessingException.class, () -> JWTTest.lambda$test_notBefore_clockSkew$7(encodedJWT, (Verifier)verifier));
        this.expectException(JWTUnavailableForProcessingException.class, () -> JWTTest.lambda$test_notBefore_clockSkew$8(encodedJWT, (Verifier)verifier));
        JWT actual = JWT.getDecoder().withClockSkew(60).decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((String)actual.subject, (String)"1234567890");
        actual = JWT.getTimeMachineDecoder((ZonedDateTime)ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(60L)).decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((String)actual.subject, (String)"1234567890");
    }

    @Test
    public void test_headerType() {
        String encodedJWT = "eyJhbGciOiJSUzI1NiIsImtpZCI6IkVCQTRGRDNDRUExMDREOTlBODkwODkyNEJBMjNDMEYwIiwidHlwIjoiYXQrand0In0.eyJuYmYiOjE2MDUwMjIwMTUsImV4cCI6MTYwNTAyMjA5MCwiaXNzIjoiaHR0cHM6Ly9kZW1vLmlkZW50aXR5c2VydmVyLmlvIiwiYXVkIjoiYXBpIiwiY2xpZW50X2lkIjoibTJtLnNob3J0IiwianRpIjoiNDUzMTY3N0YwOTg2RTM0NEEyODI4NjVFQ0VBNTM1RjciLCJpYXQiOjE2MDUwMjIwMTUsInNjb3BlIjpbImFwaSJdfQ.qYX88SwfkdexCp_uZ6JeG1k7lJwHZU-Iq8W00P4xsH4MyB8zwkIL2QJ_P8ThfsTYswi1vdD5UJyqC8mbuvJsroq2dhMvml38YU-kunFlnbYoPR_Mah4Y_IZ-Fs48EaYF_kL3PA-0uG7eZDaQHIDBj3vnBdfcdIvfkE_hPzpWE6vLunArvrrMYe2--MkJnyThgqHBxKe2XAV2GfKkkJIceNSfpw8e_cVvc_Y3YVT4uKrURPYcZA_63fI7nHmCWaBvP5K77qzmDciICosp3jhyGUMfy7GzljHqnFDy_S-DHn5OL50DUImpuodKZ5RgFw2-ty7F0SrbEd1OqMhWtMuGcw";
        Header header = JWTUtils.decodeHeader((String)encodedJWT);
        Assert.assertEquals((String)header.type, (String)"at+jwt");
    }

    @Test
    public void test_expiration_clockSkew() {
        JWT expectedJWT = new JWT().setSubject("1234567890").setExpiration(ZonedDateTime.now(ZoneOffset.UTC).minusSeconds(60L).truncatedTo(ChronoUnit.SECONDS));
        HMACSigner signer = HMACSigner.newSHA256Signer((String)"secret");
        HMACVerifier verifier = HMACVerifier.newVerifier((String)"secret");
        String encodedJWT = JWT.getEncoder().encode(expectedJWT, (Signer)signer);
        this.expectException(JWTExpiredException.class, () -> JWTTest.lambda$test_expiration_clockSkew$9(encodedJWT, (Verifier)verifier));
        this.expectException(JWTExpiredException.class, () -> JWTTest.lambda$test_expiration_clockSkew$10(encodedJWT, (Verifier)verifier));
        this.expectException(JWTExpiredException.class, () -> JWTTest.lambda$test_expiration_clockSkew$11(encodedJWT, (Verifier)verifier));
        JWT actual = JWT.getDecoder().withClockSkew(61).decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((String)actual.subject, (String)"1234567890");
        actual = JWT.getTimeMachineDecoder((ZonedDateTime)ZonedDateTime.now(ZoneOffset.UTC).minusSeconds(61L)).decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((String)actual.subject, (String)"1234567890");
    }

    @Test(invocationCount=2000)
    public void test_external_ec_521() {
        JWT jwt = new JWT().setSubject("1234567890").addClaim("name", (Object)"John Doe").addClaim("admin", (Object)true).addClaim("iat", (Object)1516239022);
        ECSigner signer = ECSigner.newSHA512Signer((String)"-----BEGIN PRIVATE KEY-----\nMIHtAgEAMBAGByqGSM49AgEGBSuBBAAjBIHVMIHSAgEBBEHzl1DpZSQJ8YhCbN/u\nvo5SOu0BjDDX9Gub6zsBW6B2TxRzb5sBeQaWVscDUZha4Xr1HEWpVtua9+nEQU/9\nAq9Pl6GBiQOBhgAEAJhvCa6S89ePqlLO6MRV9KQqHvdAITDAf/WRDcvCmfrrNuov\n+j4gQXO12ohIukPCHM9rYms8Eqciz3gaxVTxZD4CAA8i2k9H6ew9iSh1qXa1kLxi\nyzMBqmAmmg4u/SroD6OleG56SwZVbWx+KIINB6r/PQVciGX8FjwgR/mbLHotVZYD\n-----END PRIVATE KEY-----");
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer, header -> header.set("kid", (Object)"xZDfZpry4P9vZPZyG2fNBRj-7Lz5omVdm7tHoCgSNfY"));
        ECVerifier verifier = ECVerifier.newVerifier((String)"-----BEGIN PUBLIC KEY-----\nMIGbMBAGByqGSM49AgEGBSuBBAAjA4GGAAQAmG8JrpLz14+qUs7oxFX0pCoe90Ah\nMMB/9ZENy8KZ+us26i/6PiBBc7XaiEi6Q8Icz2tiazwSpyLPeBrFVPFkPgIADyLa\nT0fp7D2JKHWpdrWQvGLLMwGqYCaaDi79KugPo6V4bnpLBlVtbH4ogg0Hqv89BVyI\nZfwWPCBH+Zssei1VlgM=\n-----END PUBLIC KEY-----");
        JWT actual = JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((String)actual.subject, (String)jwt.subject);
        actual = JWT.getDecoder().decode(encodedJWT, arg_0 -> JWTTest.lambda$test_external_ec_521$13((Verifier)verifier, arg_0));
        Assert.assertEquals((String)actual.subject, (String)jwt.subject);
    }

    @Test(invocationCount=2000)
    public void test_external_ec_p256() {
        JWT jwt = new JWT().setSubject("1234567890").addClaim("name", (Object)"John Doe").addClaim("admin", (Object)true).addClaim("iat", (Object)1516239022);
        ECSigner signer = ECSigner.newSHA256Signer((String)"-----BEGIN PRIVATE KEY-----\nMIGHAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBG0wawIBAQQgPGJGAm4X1fvBuC1z\nSpO/4Izx6PXfNMaiKaS5RUkFqEGhRANCAARCBvmeksd3QGTrVs2eMrrfa7CYF+sX\nsjyGg+Bo5mPKGH4Gs8M7oIvoP9pb/I85tdebtKlmiCZHAZE5w4DfJSV6\n-----END PRIVATE KEY-----");
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer, header -> header.set("kid", (Object)"xZDfZpry4P9vZPZyG2fNBRj-7Lz5omVdm7tHoCgSNfY"));
        ECVerifier verifier = ECVerifier.newVerifier((String)"-----BEGIN PUBLIC KEY-----\nMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEQgb5npLHd0Bk61bNnjK632uwmBfr\nF7I8hoPgaOZjyhh+BrPDO6CL6D/aW/yPObXXm7SpZogmRwGROcOA3yUleg==\n-----END PUBLIC KEY-----");
        JWT actual = JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((String)actual.subject, (String)jwt.subject);
    }

    @Test(invocationCount=2000)
    public void test_external_ec_p384() {
        JWT jwt = new JWT().setSubject("1234567890").addClaim("name", (Object)"John Doe").addClaim("admin", (Object)true).addClaim("iat", (Object)1516239022);
        ECSigner signer = ECSigner.newSHA384Signer((String)"-----BEGIN PRIVATE KEY-----\nMIG2AgEAMBAGByqGSM49AgEGBSuBBAAiBIGeMIGbAgEBBDCVWQsOJHjKD0I4cXOY\nJm4G8i5c7IMhFbxFq57OUlrTVmND43dvvNW1oQ6i6NiXEQWhZANiAASezSGlAu4w\nAaJe4676mQM0F/5slI+EkdptRJdfsQP9mNxe7RdzHgcSw7j/Wxa45nlnFnFrPPL4\nviJKOBRxMB1jjVA9my9PixxJGoB22qDQwFbP8ldmEp6abwdBsXNaePM=\n-----END PRIVATE KEY-----");
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer, header -> header.set("kid", (Object)"xZDfZpry4P9vZPZyG2fNBRj-7Lz5omVdm7tHoCgSNfY"));
        ECVerifier verifier = ECVerifier.newVerifier((String)"-----BEGIN PUBLIC KEY-----\nMHYwEAYHKoZIzj0CAQYFK4EEACIDYgAEns0hpQLuMAGiXuOu+pkDNBf+bJSPhJHa\nbUSXX7ED/ZjcXu0Xcx4HEsO4/1sWuOZ5ZxZxazzy+L4iSjgUcTAdY41QPZsvT4sc\nSRqAdtqg0MBWz/JXZhKemm8HQbFzWnjz\n-----END PUBLIC KEY-----");
        JWT actual = JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((String)actual.subject, (String)jwt.subject);
        actual = JWT.getDecoder().decode(encodedJWT, arg_0 -> JWTTest.lambda$test_external_ec_p384$16((Verifier)verifier, arg_0));
        Assert.assertEquals((String)actual.subject, (String)jwt.subject);
    }

    @Test
    public void test_loading_keys() throws Exception {
        Assert.assertNotNull((Object)RSAVerifier.newVerifier((Path)this.rsaPublicKey2048Path));
        Assert.assertNotNull((Object)RSAVerifier.newVerifier((byte[])Files.readAllBytes(this.rsaPublicKey2048Path)));
        Assert.assertNotNull((Object)RSAVerifier.newVerifier((String)new String(Files.readAllBytes(this.rsaPublicKey2048Path))));
        Assert.assertNotNull((Object)RSAVerifier.newVerifier((PublicKey)((RSAPublicKey)PEM.decode((byte[])Files.readAllBytes(this.rsaPublicKey2048Path)).getPublicKey())));
        Assert.assertNotNull((Object)ECVerifier.newVerifier((Path)this.ecPublicKey256Path));
        Assert.assertNotNull((Object)ECVerifier.newVerifier((byte[])Files.readAllBytes(this.ecPublicKey256Path)));
        Assert.assertNotNull((Object)ECVerifier.newVerifier((String)new String(Files.readAllBytes(this.ecPublicKey256Path))));
        Assert.assertNotNull((Object)ECVerifier.newVerifier((PublicKey)((ECPublicKey)PEM.decode((byte[])Files.readAllBytes(this.ecPublicKey256Path)).getPublicKey())));
        Assert.assertNotNull((Object)HMACVerifier.newVerifier((Path)this.secretPath));
        Assert.assertNotNull((Object)HMACVerifier.newVerifier((byte[])Files.readAllBytes(this.secretPath)));
        Assert.assertNotNull((Object)HMACVerifier.newVerifier((String)new String(Files.readAllBytes(this.secretPath))));
    }

    @Test
    public void test_multipleSignersAndVerifiers() throws Exception {
        JWT jwt = new JWT().setSubject("123456789");
        HMACSigner signer1 = HMACSigner.newSHA512Signer((String)"secret1");
        HMACSigner signer2 = HMACSigner.newSHA512Signer((String)"secret2");
        RSASigner signer3 = RSASigner.newSHA256Signer((String)new String(Files.readAllBytes(Paths.get("src/test/resources/rsa_private_key_2048.pem", new String[0]))));
        String encodedJWT1 = JWT.getEncoder().encode(jwt, (Signer)signer1, h -> h.set("kid", (Object)"verifier1"));
        String encodedJWT2 = JWT.getEncoder().encode(jwt, (Signer)signer2, h -> h.set("kid", (Object)"verifier2"));
        String encodedJWT3 = JWT.getEncoder().encode(jwt, (Signer)signer3, h -> h.set("kid", (Object)"verifier3"));
        HMACVerifier verifier1 = HMACVerifier.newVerifier((String)"secret1");
        HMACVerifier verifier2 = HMACVerifier.newVerifier((String)"secret2");
        RSAVerifier verifier3 = RSAVerifier.newVerifier((String)new String(Files.readAllBytes(this.rsaPublicKey2048Path)));
        HashMap<String, Object> verifiers = new HashMap<String, Object>();
        verifiers.put("verifier1", verifier1);
        verifiers.put("verifier2", verifier2);
        verifiers.put("verifier3", verifier3);
        JWT jwt1 = JWT.getDecoder().decode(encodedJWT1, verifiers);
        JWT jwt2 = JWT.getDecoder().decode(encodedJWT2, verifiers);
        JWT jwt3 = JWT.getDecoder().decode(encodedJWT3, verifiers);
        Assert.assertEquals((String)jwt1.subject, (String)jwt2.subject);
        Assert.assertEquals((String)jwt2.subject, (String)jwt3.subject);
    }

    @Test
    public void test_none() {
        JWT jwt = new JWT().setSubject("123456789");
        UnsecuredSigner signer = new UnsecuredSigner();
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer);
        Assert.assertEquals((String)encodedJWT, (String)"eyJhbGciOiJub25lIiwidHlwIjoiSldUIn0.eyJzdWIiOiIxMjM0NTY3ODkifQ.");
        JWT actual = JWT.getDecoder().decode(encodedJWT, new Verifier[0]);
        Assert.assertEquals((String)actual.subject, (String)jwt.subject);
        this.expectException(InvalidJWTException.class, () -> JWT.getDecoder().decode("eyJhbGciOiJub25lIiwidHlwIjoiSldUIn0.eyJzdWIiOiIxMjM0NTY3ODkifQ", new Verifier[0]));
    }

    @Test
    public void test_notBeforeThrows() {
        JWT expectedJWT = new JWT().setExpiration(ZonedDateTime.now(ZoneOffset.UTC).plusMinutes(60L).truncatedTo(ChronoUnit.SECONDS)).setIssuedAt(ZonedDateTime.now(ZoneOffset.UTC).truncatedTo(ChronoUnit.SECONDS)).setIssuer("www.inversoft.com").setNotBefore(ZonedDateTime.now(ZoneOffset.UTC).plusMinutes(5L).truncatedTo(ChronoUnit.SECONDS));
        HMACSigner signer = HMACSigner.newSHA256Signer((String)"secret");
        HMACVerifier verifier = HMACVerifier.newVerifier((String)"secret");
        String encodedJWT = JWT.getEncoder().encode(expectedJWT, (Signer)signer);
        this.expectException(JWTUnavailableForProcessingException.class, () -> JWTTest.lambda$test_notBeforeThrows$21(encodedJWT, (Verifier)verifier));
    }

    @Test
    public void test_nullFailFast() {
        this.expectException(NullPointerException.class, () -> new JWTDecoder().decode(null, new Verifier[0]));
        this.expectException(NullPointerException.class, () -> new JWTDecoder().decode(null, new Verifier[]{null, null, null}));
        this.expectException(NullPointerException.class, () -> new JWTDecoder().decode("foo", Collections.emptyMap(), null));
        this.expectException(NullPointerException.class, () -> new JWTDecoder().decode("foo", key -> null, null));
        this.expectException(NullPointerException.class, () -> new JWTDecoder().decode("foo", key -> null, null));
    }

    @Test
    public void test_openssl_keys_p_256() {
        JWT jwt = new JWT().setSubject("1234567890").addClaim("name", (Object)"John Doe").addClaim("admin", (Object)true).addClaim("iat", (Object)1516239022);
        ECSigner signer = ECSigner.newSHA256Signer((String)"-----BEGIN PRIVATE KEY-----\nMIGHAgEAMBMGByqGSM49AgEGCCqGSM49AwEHBG0wawIBAQQgy3F4UN/uqaNn4o4G\n8UHT3Gq6Ab/2CdjFeoDpLREcGaChRANCAAR2dqbsTukFi1nBHI4wOOApeczUf8pG\n8g+hsTDTedkDj4q9686mgx+OwHwbT5XOt+sNEhyz0jxUz6Vy+6l6DeUQ\n-----END PRIVATE KEY-----");
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer, header -> header.set("kid", (Object)"xZDfZpry4P9vZPZyG2fNBRj-7Lz5omVdm7tHoCgSNfY"));
        ECVerifier verifier = ECVerifier.newVerifier((String)"-----BEGIN PUBLIC KEY-----\nMFkwEwYHKoZIzj0CAQYIKoZIzj0DAQcDQgAEdnam7E7pBYtZwRyOMDjgKXnM1H/K\nRvIPobEw03nZA4+KvevOpoMfjsB8G0+VzrfrDRIcs9I8VM+lcvupeg3lEA==\n-----END PUBLIC KEY-----");
        JWT actual = JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((String)actual.subject, (String)jwt.subject);
    }

    @Test(invocationCount=2000)
    public void test_openssl_keys_p_521() {
        JWT jwt = new JWT().setSubject("1234567890").addClaim("name", (Object)"John Doe").addClaim("admin", (Object)true).addClaim("iat", (Object)1516239022);
        ECSigner signer = ECSigner.newSHA512Signer((String)"-----BEGIN PRIVATE KEY-----\nMIHtAgEAMBAGByqGSM49AgEGBSuBBAAjBIHVMIHSAgEBBEHdgM7Q2N5VAu1JXri9\n5AYmCZo+rVbdtYbz58D0mWB+TZs8YPvawg6u3m1xGNJXoqPBr/KSVvqHkpgLONlU\nNGs5t6GBiQOBhgAEAYsJ/uVsOJR5FrCynbKsuWhkj/+2PdFnIlnJp1s0l0T13gtE\niIcpzSDLHuvJS3812NlC5ZYGvhqIoWfMBy4KTfdyAenIeyriM/P6gJeR1HYMZIP0\nPFNr0EghmYCIK51MamQAlEcvhoPri1phF6Fa6mZtrCqaaIB3VDNRaabcJfsFHl94\n-----END PRIVATE KEY-----");
        String encodedJWT = JWT.getEncoder().encode(jwt, (Signer)signer, header -> header.set("kid", (Object)"xZDfZpry4P9vZPZyG2fNBRj-7Lz5omVdm7tHoCgSNfY"));
        ECVerifier verifier = ECVerifier.newVerifier((String)"-----BEGIN PUBLIC KEY-----\nMIGbMBAGByqGSM49AgEGBSuBBAAjA4GGAAQBiwn+5Ww4lHkWsLKdsqy5aGSP/7Y9\n0WciWcmnWzSXRPXeC0SIhynNIMse68lLfzXY2ULllga+GoihZ8wHLgpN93IB6ch7\nKuIz8/qAl5HUdgxkg/Q8U2vQSCGZgIgrnUxqZACURy+Gg+uLWmEXoVrqZm2sKppo\ngHdUM1Fpptwl+wUeX3g=\n-----END PUBLIC KEY-----");
        JWT actual = JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
        Assert.assertEquals((String)actual.subject, (String)jwt.subject);
    }

    @Test
    public void test_zonedDateTime() {
        ZonedDateTime expiration = ZonedDateTime.now(ZoneOffset.UTC).plusMinutes(60L).truncatedTo(ChronoUnit.SECONDS);
        JWT expectedJWT = new JWT().setExpiration(expiration);
        HMACSigner signer = HMACSigner.newSHA256Signer((String)"secret");
        HMACVerifier verifier = HMACVerifier.newVerifier((String)"secret");
        String encodedJWT1 = JWT.getEncoder().encode(expectedJWT, (Signer)signer);
        JWT actualJWT1 = JWT.getDecoder().decode(encodedJWT1, new Verifier[]{verifier});
        Assert.assertEquals((Object)actualJWT1.expiration, (Object)expectedJWT.expiration);
    }

    private static /* synthetic */ void lambda$test_notBeforeThrows$21(String encodedJWT, Verifier verifier) throws Exception {
        JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
    }

    private static /* synthetic */ Verifier lambda$test_external_ec_p384$16(Verifier verifier, String key) {
        return verifier;
    }

    private static /* synthetic */ Verifier lambda$test_external_ec_521$13(Verifier verifier, String key) {
        return verifier;
    }

    private static /* synthetic */ void lambda$test_expiration_clockSkew$11(String encodedJWT, Verifier verifier) throws Exception {
        JWT.getTimeMachineDecoder((ZonedDateTime)ZonedDateTime.now(ZoneOffset.UTC).minusSeconds(60L)).decode(encodedJWT, new Verifier[]{verifier});
    }

    private static /* synthetic */ void lambda$test_expiration_clockSkew$10(String encodedJWT, Verifier verifier) throws Exception {
        JWT.getDecoder().withClockSkew(60).decode(encodedJWT, new Verifier[]{verifier});
    }

    private static /* synthetic */ void lambda$test_expiration_clockSkew$9(String encodedJWT, Verifier verifier) throws Exception {
        JWT.getDecoder().withClockSkew(59).decode(encodedJWT, new Verifier[]{verifier});
    }

    private static /* synthetic */ void lambda$test_notBefore_clockSkew$8(String encodedJWT, Verifier verifier) throws Exception {
        JWT.getTimeMachineDecoder((ZonedDateTime)ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(59L)).decode(encodedJWT, new Verifier[]{verifier});
    }

    private static /* synthetic */ void lambda$test_notBefore_clockSkew$7(String encodedJWT, Verifier verifier) throws Exception {
        JWT.getDecoder().withClockSkew(59).decode(encodedJWT, new Verifier[]{verifier});
    }

    private static /* synthetic */ void lambda$test_expiredThrows$6(String encodedJWT, Verifier verifier) throws Exception {
        JWT.getDecoder().decode(encodedJWT, new Verifier[]{verifier});
    }

    private static /* synthetic */ void lambda$test_badEncoding$4(Verifier verifier) throws Exception {
        JWT.getDecoder().decode("eyJhbGciOiJSUzI1NiIsInR5cCI6IkpXVCJ9 .foo.bar", new Verifier[]{verifier});
    }
}

