/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.http;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import io.fusionauth.http.ExpectedResponse;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.stream.Collectors;

public class BuilderHTTPHandler
implements HttpHandler {
    public String actualRequestBody;
    public int called = 0;
    public Map<String, ExpectedResponse> responses;

    public BuilderHTTPHandler(Map<String, ExpectedResponse> responses) {
        this.responses = responses;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        ++this.called;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(httpExchange.getRequestBody(), StandardCharsets.UTF_8));){
            this.actualRequestBody = reader.lines().collect(Collectors.joining(System.lineSeparator()));
        }
        String requestedURI = httpExchange.getRequestURI().toString();
        ExpectedResponse expectedResult = this.responses.get(requestedURI);
        if (expectedResult == null) {
            httpExchange.sendResponseHeaders(200, 0L);
            httpExchange.getResponseBody().close();
            return;
        }
        byte[] bytes = expectedResult.response == null ? new byte[]{} : expectedResult.response.getBytes(StandardCharsets.UTF_8);
        httpExchange.sendResponseHeaders(expectedResult.status, bytes.length);
        if (bytes.length != 0) {
            httpExchange.getResponseBody().write(bytes);
            httpExchange.getResponseBody().flush();
        }
        if (expectedResult.contentType != null) {
            httpExchange.getResponseHeaders().add("Content-Type", expectedResult.contentType);
        }
        httpExchange.getResponseBody().close();
    }
}

