/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.der;

import io.fusionauth.der.DerDecodingException;
import io.fusionauth.der.ObjectIdentifier;
import io.fusionauth.jwt.BaseJWTTest;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ObjectIdentifierTest
extends BaseJWTTest {
    @Test
    public void decode() throws Exception {
        Assert.assertEquals((String)this.decode(42, 134, 72, 206, 61, 2, 1), (String)"1.2.840.10045.2.1");
        Assert.assertEquals((String)this.decode(42, 134, 72, 206, 61, 3, 1, 7), (String)"1.2.840.10045.3.1.7");
        Assert.assertEquals((String)this.decode(43, 129, 4, 0, 34), (String)"1.3.132.0.34");
        Assert.assertEquals((String)this.decode(43, 129, 4, 0, 35), (String)"1.3.132.0.35");
        Assert.assertEquals((String)this.decode(43, 101, 112), (String)"1.3.101.112");
        Assert.assertEquals((String)this.decode(43, 101, 113), (String)"1.3.101.113");
        Assert.assertEquals((String)this.decode(42, 134, 72, 134, 247, 13, 1, 1, 1), (String)"1.2.840.113549.1.1.1");
        Assert.assertEquals((String)this.decode(42, 134, 72, 134, 247, 13, 1, 1, 11), (String)"1.2.840.113549.1.1.11");
        Assert.assertEquals((String)this.decode(42, 134, 72, 134, 247, 13, 1, 1, 12), (String)"1.2.840.113549.1.1.12");
        Assert.assertEquals((String)this.decode(42, 134, 72, 134, 247, 13, 1, 1, 13), (String)"1.2.840.113549.1.1.13");
        Assert.assertEquals((String)this.decode(81, 1), (String)"2.1.1");
        Assert.assertEquals((String)this.decode(81, 3, 0, 1), (String)"2.1.3.0.1");
        Assert.assertEquals((String)this.decode(43, 6, 1, 4, 1, 174, 35, 1, 3, 1), (String)"1.3.6.1.4.1.5923.1.3.1");
        Assert.assertEquals((String)this.decode(43, 6, 1, 4, 1, 154, 47, 2, 1, 2, 4, 1, 2, 1, 17), (String)"1.3.6.1.4.1.3375.2.1.2.4.1.2.1.17");
        Assert.assertEquals((String)this.decode(83, 6, 1, 4, 1, 174, 35, 1, 3, 1), (String)"2.3.6.1.4.1.5923.1.3.1");
        Assert.assertEquals((String)this.decode(83, 6, 134, 244, 97, 134, 231, 61, 1, 135, 165, 125, 1, 3, 1), (String)"2.3.6.113249.111549.1.119549.1.3.1");
        this.expectException(DerDecodingException.class, () -> Assert.assertEquals((String)this.decode(81, 135, 255, 255, 255, 127, 1), (String)"2.1.2147483647.1"));
    }

    private String decode(int ... array) throws DerDecodingException {
        byte[] bytes = new byte[array.length];
        for (int i = 0; i < bytes.length; ++i) {
            bytes[i] = (byte)array[i];
        }
        return new ObjectIdentifier(bytes).decode();
    }
}

