/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.jwt.ec;

import io.fusionauth.jwt.InvalidJWTSignatureException;
import io.fusionauth.jwt.InvalidKeyTypeException;
import io.fusionauth.jwt.JWTVerifierException;
import io.fusionauth.jwt.MissingPublicKeyException;
import io.fusionauth.jwt.Verifier;
import io.fusionauth.jwt.domain.Algorithm;
import io.fusionauth.jwt.ec.ECDSASignature;
import io.fusionauth.pem.domain.PEM;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.ECPublicKey;
import java.util.Objects;

public class ECVerifier
implements Verifier {
    private final ECPublicKey publicKey;

    private ECVerifier(PublicKey publicKey) {
        Objects.requireNonNull(publicKey);
        if (!(publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyTypeException("Expecting a public key of type [ECPublicKey], but found [" + publicKey.getClass().getSimpleName() + "].");
        }
        this.publicKey = (ECPublicKey)publicKey;
    }

    private ECVerifier(String publicKey) {
        Objects.requireNonNull(publicKey);
        PEM pem = PEM.decode(publicKey);
        if (pem.publicKey == null) {
            throw new MissingPublicKeyException("The provided PEM encoded string did not contain a public key.");
        }
        if (!(pem.publicKey instanceof ECPublicKey)) {
            throw new InvalidKeyTypeException("Expecting a public key of type [ECPublicKey], but found [" + pem.publicKey.getClass().getSimpleName() + "].");
        }
        this.publicKey = (ECPublicKey)pem.getPublicKey();
    }

    public static ECVerifier newVerifier(String publicKey) {
        return new ECVerifier(publicKey);
    }

    public static ECVerifier newVerifier(PublicKey publicKey) {
        return new ECVerifier(publicKey);
    }

    public static ECVerifier newVerifier(Path path) {
        Objects.requireNonNull(path);
        try {
            return new ECVerifier(new String(Files.readAllBytes(path)));
        }
        catch (IOException e) {
            throw new JWTVerifierException("Unable to read the file from path [" + path.toAbsolutePath() + "]", e);
        }
    }

    public static ECVerifier newVerifier(byte[] bytes) {
        Objects.requireNonNull(bytes);
        return new ECVerifier(new String(bytes));
    }

    @Override
    public boolean canVerify(Algorithm algorithm) {
        return switch (algorithm) {
            case Algorithm.ES256, Algorithm.ES384, Algorithm.ES512 -> true;
            default -> false;
        };
    }

    private void checkFor_CVE_2022_21449(byte[] signature) {
        int half = signature.length / 2;
        boolean rOk = false;
        boolean sOk = false;
        for (int i = 0; i < signature.length; ++i) {
            if (i < half) {
                boolean bl = rOk = signature[i] != 0;
                if (!rOk) continue;
                i = half - 1;
                continue;
            }
            boolean bl = sOk = signature[i] != 0;
            if (sOk) break;
        }
        if (!rOk || !sOk) {
            throw new InvalidJWTSignatureException();
        }
    }

    @Override
    public void verify(Algorithm algorithm, byte[] message, byte[] signature) {
        Objects.requireNonNull(algorithm);
        Objects.requireNonNull(message);
        Objects.requireNonNull(signature);
        this.checkFor_CVE_2022_21449(signature);
        try {
            Signature verifier = Signature.getInstance(algorithm.getName());
            verifier.initVerify(this.publicKey);
            verifier.update(message);
            byte[] derEncoded = new ECDSASignature(signature).derEncode();
            if (!verifier.verify(derEncoded)) {
                throw new InvalidJWTSignatureException();
            }
        }
        catch (IOException | SecurityException | InvalidKeyException | NoSuchAlgorithmException | SignatureException e) {
            throw new JWTVerifierException("An unexpected exception occurred when attempting to verify the JWT", e);
        }
    }
}

