/*
 * Copyright (c) 2025, FusionAuth, All Rights Reserved
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package io.fusionauth.domain.form;

/**
 * Denotes the type of form step. This is used to configure different behavior on form steps in the registration flow.
 */
public enum FormStepType {
  // NOTE: These are ordinal, always add to the end
  /**
   * Collects data from the user.
   */
  collectData,
  /**
   * Verifies the user's email address before creating the user.
   */
  verifyEmail,
  /**
   * Verifies the user's phone number before creating the user.
   */
  verifyPhoneNumber
}
