/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.client;

import com.inversoft.rest.ClientResponse;
import io.fusionauth.client.FusionAuthClient;
import io.fusionauth.domain.User;
import io.fusionauth.domain.api.UserRequest;
import io.fusionauth.domain.api.UserResponse;
import io.fusionauth.domain.api.user.ForgotPasswordRequest;
import io.fusionauth.domain.api.user.ForgotPasswordResponse;
import org.testng.Assert;
import org.testng.annotations.Test;

public class FusionAuthClientTest {
    @Test
    public void forgotPassword_with_and_without_api_key() {
        String fusionauthURL = System.getenv().getOrDefault("FUSIONAUTH_URL", "http://localhost:9011");
        String fusionauthApiKey = System.getenv().getOrDefault("FUSIONAUTH_API_KEY", "api-key");
        FusionAuthClient apiKeyClient = new FusionAuthClient(fusionauthApiKey, fusionauthURL);
        ClientResponse userResponse = apiKeyClient.retrieveUserByEmail("client_java@fusionauth.io");
        if (userResponse.status != 404) {
            apiKeyClient.deleteUser(((UserResponse)userResponse.successResponse).user.id);
        }
        ClientResponse response = apiKeyClient.createUser(null, new UserRequest(null, (User)((User)new User().with(u -> {
            u.email = "client_java@fusionauth.io";
        })).with(u -> {
            u.password = "password";
        })));
        Assert.assertTrue((boolean)response.wasSuccessful());
        ClientResponse forgotPasswordResponse = apiKeyClient.forgotPassword(new ForgotPasswordRequest(((UserResponse)response.successResponse).user.email, false));
        Assert.assertTrue((boolean)forgotPasswordResponse.wasSuccessful());
        Assert.assertNotNull((Object)forgotPasswordResponse.successResponse);
        Assert.assertNotNull((Object)((ForgotPasswordResponse)forgotPasswordResponse.successResponse).changePasswordId);
        FusionAuthClient noApiKeyClient = new FusionAuthClient(null, fusionauthURL);
        forgotPasswordResponse = noApiKeyClient.forgotPassword(new ForgotPasswordRequest(((UserResponse)response.successResponse).user.email, false));
        Assert.assertTrue((boolean)forgotPasswordResponse.wasSuccessful());
        Assert.assertNull((Object)forgotPasswordResponse.successResponse);
    }
}

