/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.webauthn;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;

public enum CoseKeyType {
    Reserved(0),
    OKP(1),
    EC2(2),
    RSA(3),
    Symmetric(4);

    private static final Map<Integer, CoseKeyType> valueMap;
    @JsonValue
    public final int registryId;

    private CoseKeyType(int registryId) {
        this.registryId = registryId;
    }

    @JsonCreator
    public static CoseKeyType forValue(int value) {
        return valueMap.get(value);
    }

    static {
        valueMap = new HashMap<Integer, CoseKeyType>();
        for (CoseKeyType k : CoseKeyType.values()) {
            valueMap.put(k.registryId, k);
        }
    }
}

