/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.Enableable;
import io.fusionauth.domain.util.HTTPMethod;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;

public class CORSConfiguration
extends Enableable
implements Buildable<CORSConfiguration> {
    public boolean allowCredentials;
    public List<String> allowedHeaders = new ArrayList<String>();
    public List<HTTPMethod> allowedMethods = new ArrayList<HTTPMethod>();
    public List<URI> allowedOrigins = new ArrayList<URI>();
    public boolean debug;
    public List<String> exposedHeaders = new ArrayList<String>();
    public int preflightMaxAgeInSeconds;

    @JacksonConstructor
    public CORSConfiguration() {
    }

    public CORSConfiguration(CORSConfiguration other) {
        this.allowCredentials = other.allowCredentials;
        this.allowedHeaders.addAll(other.allowedHeaders);
        this.allowedMethods.addAll(other.allowedMethods);
        this.allowedOrigins.addAll(other.allowedOrigins);
        this.debug = other.debug;
        this.enabled = other.enabled;
        this.exposedHeaders.addAll(other.exposedHeaders);
        this.preflightMaxAgeInSeconds = other.preflightMaxAgeInSeconds;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CORSConfiguration that = (CORSConfiguration)o;
        return this.allowCredentials == that.allowCredentials && this.debug == that.debug && this.preflightMaxAgeInSeconds == that.preflightMaxAgeInSeconds && Objects.equals(this.allowedHeaders, that.allowedHeaders) && Objects.equals(this.allowedMethods, that.allowedMethods) && Objects.equals(this.allowedOrigins, that.allowedOrigins) && Objects.equals(this.exposedHeaders, that.exposedHeaders);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.allowCredentials, this.allowedHeaders, this.allowedMethods, this.allowedOrigins, this.debug, this.exposedHeaders, this.preflightMaxAgeInSeconds);
    }

    public void normalize() {
        HashSet<HTTPMethod> methods = new HashSet<HTTPMethod>(this.allowedMethods);
        this.allowedMethods.clear();
        this.allowedMethods.addAll(methods);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

