/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.client.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.fusionauth.client.json.IdentityProviderJacksonHelper;
import io.fusionauth.domain.api.IdentityProviderRequest;
import io.fusionauth.domain.provider.BaseIdentityProvider;
import io.fusionauth.domain.provider.IdentityProviderType;
import java.io.IOException;

public class IdentityProviderRequestDeserializer
extends StdDeserializer<IdentityProviderRequest> {
    public IdentityProviderRequestDeserializer() {
        super(IdentityProviderRequest.class);
    }

    public IdentityProviderRequest deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserialize(p, ctxt, new IdentityProviderRequest());
    }

    public IdentityProviderRequest deserialize(JsonParser p, DeserializationContext ctxt, IdentityProviderRequest req) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        JsonNode idpNode = node.at("/identityProvider");
        if (req.identityProvider == null) {
            IdentityProviderType idpType = IdentityProviderJacksonHelper.extractType(ctxt, p, idpNode);
            req.identityProvider = IdentityProviderJacksonHelper.newIdentityProvider(idpType);
        }
        if (p.getCodec() instanceof ObjectMapper) {
            ((ObjectMapper)p.getCodec()).readerForUpdating(req.identityProvider).readValue(idpNode);
        } else if (p.getCodec() instanceof ObjectReader) {
            req.identityProvider = (BaseIdentityProvider)((ObjectReader)p.getCodec()).readValue(idpNode, req.identityProvider.getClass());
        }
        return req;
    }
}

