/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.WebhookAttemptResult;
import io.fusionauth.domain.WebhookCallResponse;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;

public class WebhookAttemptLog
implements Buildable<WebhookAttemptLog>,
Comparable<WebhookAttemptLog> {
    public Map<String, Object> data = new LinkedHashMap<String, Object>();
    public ZonedDateTime endInstant;
    public UUID id;
    public ZonedDateTime startInstant;
    public WebhookCallResponse webhookCallResponse;
    public UUID webhookEventLogId;
    public UUID webhookId;

    @Override
    public int compareTo(WebhookAttemptLog o) {
        return this.startInstant.compareTo(o.startInstant) != 0 ? this.startInstant.compareTo(o.startInstant) : this.id.compareTo(o.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebhookAttemptLog that = (WebhookAttemptLog)o;
        return Objects.equals(this.data, that.data) && Objects.equals(this.endInstant, that.endInstant) && Objects.equals(this.id, that.id) && Objects.equals(this.startInstant, that.startInstant) && Objects.equals(this.webhookCallResponse, that.webhookCallResponse) && Objects.equals(this.webhookEventLogId, that.webhookEventLogId) && Objects.equals(this.webhookId, that.webhookId);
    }

    public WebhookAttemptResult getAttemptResult() {
        if (this.webhookCallResponse != null) {
            return this.webhookCallResponse.statusCode >= 200 && this.webhookCallResponse.statusCode <= 299 ? WebhookAttemptResult.Success : WebhookAttemptResult.Failure;
        }
        return WebhookAttemptResult.Unknown;
    }

    @JsonIgnore
    public long getDuration() {
        return Duration.between(this.startInstant, this.endInstant).toMillis();
    }

    @JsonIgnore
    public String getUrl() {
        return this.webhookCallResponse != null && this.webhookCallResponse.url != null ? this.webhookCallResponse.url.toString() : null;
    }

    public int hashCode() {
        return Objects.hash(this.data, this.endInstant, this.id, this.startInstant, this.webhookCallResponse, this.webhookEventLogId, this.webhookId);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

