/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.UserActionLog;
import io.fusionauth.domain.util.Normalizer;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.UUID;

public class UserComment
implements Buildable<UserComment> {
    public String comment;
    public UUID commenterId;
    public UUID id;
    public ZonedDateTime insertInstant;
    public UUID userId;

    public UserComment() {
    }

    public UserComment(String comment, ZonedDateTime insertInstant, UUID id, UUID userId, UUID commenterId) {
        this.comment = comment;
        this.insertInstant = insertInstant;
        this.id = id;
        this.userId = userId;
        this.commenterId = commenterId;
    }

    public static UserActionLog toUserActionLog(UserComment userComment) {
        return new UserActionLog().with(l -> {
            l.actioneeUserId = userComment.userId;
        }).with(l -> {
            l.actionerUserId = userComment.commenterId;
        }).with(l -> {
            l.comment = userComment.comment;
        }).with(l -> {
            l.insertInstant = userComment.insertInstant;
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserComment)) {
            return false;
        }
        UserComment that = (UserComment)o;
        return Objects.equals(this.comment, that.comment) && Objects.equals(this.commenterId, that.commenterId) && Objects.equals(this.id, that.id) && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.userId, that.userId);
    }

    public int hashCode() {
        return Objects.hash(this.comment, this.commenterId, this.id, this.insertInstant, this.userId);
    }

    public void normalize() {
        this.comment = Normalizer.trim(this.comment);
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

