/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.client.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.fusionauth.domain.WebhookEventLog;
import io.fusionauth.domain.event.BaseEvent;
import io.fusionauth.domain.event.EventType;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.stream.Collectors;

public class WebhookEventDeserializer
extends StdDeserializer<BaseEvent> {
    public WebhookEventDeserializer() {
        super(WebhookEventLog.class);
    }

    public BaseEvent deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        BaseEvent newEvent = this.extractEventType(ctxt, p, node);
        return (BaseEvent)((ObjectMapper)p.getCodec()).readerForUpdating((Object)newEvent).readValue(node);
    }

    private BaseEvent extractEventType(DeserializationContext ctxt, JsonParser p, JsonNode eventNode) throws IOException {
        JsonNode node = eventNode.at("/type");
        String type = node.asText();
        EventType eventType = EventType.forValue(type);
        if (eventType == null) {
            String sorted = Arrays.stream(EventType.values()).map(Enum::name).sorted().collect(Collectors.joining(", "));
            return (BaseEvent)ctxt.handleUnexpectedToken(BaseEvent.class, node.asToken(), p, "Expected the type field to be one of [" + sorted + "], but found [" + node.asText() + "]", new Object[0]);
        }
        String className = BaseEvent.class.getPackage().getName() + "." + eventType.name() + "Event";
        try {
            Constructor<?> constructor = Class.forName(className).getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return (BaseEvent)constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("Unexpected type [" + (Object)((Object)eventType) + "]. This is a FusionAuth bug, could not instantiate class [" + className + "].");
        }
    }
}

