/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.EventInfo;
import io.fusionauth.domain.User;
import io.fusionauth.domain.UserRegistration;
import io.fusionauth.domain.event.BaseUserEvent;
import io.fusionauth.domain.event.EventType;
import java.util.Objects;
import java.util.UUID;

public class UserRegistrationCreateEvent
extends BaseUserEvent
implements Buildable<UserRegistrationCreateEvent> {
    public UUID applicationId;
    public UserRegistration registration;

    public UserRegistrationCreateEvent(EventInfo info, UUID applicationId, UserRegistration registration, User user) {
        super(info, user);
        this.user.getRegistrations().clear();
        this.applicationId = applicationId;
        this.registration = registration;
    }

    @JacksonConstructor
    private UserRegistrationCreateEvent() {
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        UserRegistrationCreateEvent that = (UserRegistrationCreateEvent)o;
        return Objects.equals(this.applicationId, that.applicationId) && Objects.equals(this.registration, that.registration);
    }

    @Override
    public EventType getType() {
        return EventType.UserRegistrationCreate;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.applicationId, this.registration);
    }
}

