/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.event;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.EventInfo;
import io.fusionauth.domain.User;
import io.fusionauth.domain.event.BaseUserEvent;
import io.fusionauth.domain.event.EventType;
import java.util.Objects;
import java.util.UUID;

public class UserIdentityVerifiedEvent
extends BaseUserEvent
implements Buildable<UserIdentityVerifiedEvent> {
    public final String loginId;
    public final String loginIdType;

    public UserIdentityVerifiedEvent(EventInfo info, String loginId, String loginIdType, User user) {
        super(info, user);
        this.loginId = loginId;
        this.loginIdType = loginIdType;
    }

    @JacksonConstructor
    private UserIdentityVerifiedEvent() {
        this.loginId = null;
        this.loginIdType = null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UserIdentityVerifiedEvent that = (UserIdentityVerifiedEvent)o;
        return Objects.equals(this.loginId, that.loginId) && Objects.equals(this.loginIdType, that.loginIdType);
    }

    @Override
    public UUID getLinkedObjectId() {
        return this.user != null ? super.getLinkedObjectId() : null;
    }

    @Override
    public EventType getType() {
        return EventType.UserIdentityVerified;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.loginId, this.loginIdType);
    }
}

