/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.CaptchaMethod;
import io.fusionauth.domain.Enableable;
import java.util.Objects;

public class TenantCaptchaConfiguration
extends Enableable
implements Buildable<TenantCaptchaConfiguration> {
    public CaptchaMethod captchaMethod = CaptchaMethod.GoogleRecaptchaV3;
    public String secretKey;
    public String siteKey;
    public double threshold = 0.5;

    @JacksonConstructor
    public TenantCaptchaConfiguration() {
    }

    public TenantCaptchaConfiguration(TenantCaptchaConfiguration other) {
        this.captchaMethod = other.captchaMethod;
        this.enabled = other.enabled;
        this.secretKey = other.secretKey;
        this.siteKey = other.siteKey;
        this.threshold = other.threshold;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantCaptchaConfiguration that = (TenantCaptchaConfiguration)o;
        return Double.compare(that.threshold, this.threshold) == 0 && this.captchaMethod == that.captchaMethod && Objects.equals(this.secretKey, that.secretKey) && Objects.equals(this.siteKey, that.siteKey);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.captchaMethod, this.secretKey, this.siteKey, this.threshold});
    }

    public String toString() {
        return ToString.toString((Object)this);
    }
}

