/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain.search;

import com.inversoft.json.JacksonConstructor;
import io.fusionauth.domain.EventLogType;
import io.fusionauth.domain.search.BaseSearchCriteria;
import io.fusionauth.domain.util.SQLTools;
import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class EventLogSearchCriteria
extends BaseSearchCriteria {
    public static final Map<String, String> SortableFields = new LinkedHashMap<String, String>();
    public ZonedDateTime end;
    public String message;
    public ZonedDateTime start;
    public EventLogType type;

    @JacksonConstructor
    public EventLogSearchCriteria() {
    }

    public EventLogSearchCriteria(String message, EventLogType type, ZonedDateTime start, ZonedDateTime end, int startRow, int numberOfResults, String orderBy) {
        this.end = end;
        this.message = message;
        this.numberOfResults = numberOfResults;
        this.orderBy = orderBy;
        this.start = start;
        this.startRow = startRow;
        this.type = type;
    }

    public EventLogSearchCriteria(int startRow, int numberOfResults) {
        this.prepare();
        this.numberOfResults = numberOfResults;
        this.startRow = startRow;
    }

    @Override
    public EventLogSearchCriteria prepare() {
        if (this.orderBy == null) {
            this.orderBy = this.defaultOrderBy();
        }
        this.orderBy = SQLTools.normalizeOrderBy(this.orderBy, SortableFields);
        this.message = SQLTools.toSearchString(this.message);
        return this;
    }

    @Override
    public Set<String> supportedOrderByColumns() {
        return SortableFields.keySet();
    }

    @Override
    protected String defaultOrderBy() {
        return "insertInstant DESC, id DESC";
    }

    static {
        SortableFields.put("id", "id");
        SortableFields.put("insertInstant", "insert_instant");
        SortableFields.put("message", "message");
        SortableFields.put("type", "type");
    }
}

