/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.domain;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.inversoft.json.JacksonConstructor;
import com.inversoft.json.ToString;
import io.fusionauth.domain.Buildable;
import io.fusionauth.domain.ContentStatus;
import io.fusionauth.domain.IdentityType;
import io.fusionauth.domain.IdentityVerifiedReason;
import io.fusionauth.domain.util.Normalizer;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.UUID;

public class UserIdentity
implements Buildable<UserIdentity> {
    public String displayValue;
    @JsonIgnore
    public Long id;
    public ZonedDateTime insertInstant;
    public ZonedDateTime lastLoginInstant;
    public ZonedDateTime lastUpdateInstant;
    public ContentStatus moderationStatus;
    public boolean primary = true;
    @JsonIgnore
    public UUID tenantId;
    public IdentityType type;
    @JsonIgnore
    public UUID userId;
    public String value;
    public boolean verified;
    public ZonedDateTime verifiedInstant;
    public IdentityVerifiedReason verifiedReason;

    public UserIdentity(UserIdentity other) {
        this.id = other.id;
        this.insertInstant = other.insertInstant;
        this.lastLoginInstant = other.lastLoginInstant;
        this.lastUpdateInstant = other.lastUpdateInstant;
        this.moderationStatus = other.moderationStatus;
        this.primary = other.primary;
        this.type = new IdentityType(other.type);
        this.tenantId = other.tenantId;
        this.displayValue = other.displayValue;
        this.userId = other.userId;
        this.value = other.value;
        this.verified = other.verified;
        this.verifiedReason = other.verifiedReason;
        this.verifiedInstant = other.verifiedInstant;
    }

    @JacksonConstructor
    public UserIdentity() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UserIdentity)) {
            return false;
        }
        UserIdentity that = (UserIdentity)o;
        return Objects.equals(this.id, that.id) && this.primary == that.primary && this.verified == that.verified && this.verifiedReason == that.verifiedReason && Objects.equals(this.insertInstant, that.insertInstant) && Objects.equals(this.lastLoginInstant, that.lastLoginInstant) && Objects.equals(this.lastUpdateInstant, that.lastUpdateInstant) && this.moderationStatus == that.moderationStatus && Objects.equals(this.tenantId, that.tenantId) && Objects.equals(this.type, that.type) && Objects.equals(this.displayValue, that.displayValue) && Objects.equals(this.userId, that.userId) && Objects.equals(this.value, that.value) && Objects.equals(this.verifiedInstant, that.verifiedInstant);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.insertInstant, this.lastLoginInstant, this.lastUpdateInstant, this.moderationStatus, this.primary, this.tenantId, this.type, this.displayValue, this.userId, this.value, this.verified, this.verifiedReason, this.verifiedInstant});
    }

    public void normalize() {
        this.value = Normalizer.trim(this.value);
        if (this.value != null && this.value.length() == 0) {
            this.value = null;
        }
    }

    public String toString() {
        return ToString.toString((Object)this);
    }

    public boolean verificationRequired() {
        return !this.verified && !IdentityVerifiedReason.Disabled.equals((Object)this.verifiedReason) && !IdentityVerifiedReason.Import.equals((Object)this.verifiedReason) && !IdentityVerifiedReason.Trusted.equals((Object)this.verifiedReason) && !IdentityVerifiedReason.Skipped.equals((Object)this.verifiedReason) && !IdentityVerifiedReason.Unverifiable.equals((Object)this.verifiedReason);
    }
}

