/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.client.json;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import io.fusionauth.client.json.ConnectorJacksonHelper;
import io.fusionauth.domain.api.ConnectorRequest;
import io.fusionauth.domain.connector.BaseConnectorConfiguration;
import io.fusionauth.domain.connector.ConnectorType;
import java.io.IOException;

public class ConnectorRequestDeserializer
extends StdDeserializer<ConnectorRequest> {
    public ConnectorRequestDeserializer() {
        super(ConnectorRequest.class);
    }

    public ConnectorRequest deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        return this.deserialize(p, ctxt, new ConnectorRequest());
    }

    public ConnectorRequest deserialize(JsonParser p, DeserializationContext ctxt, ConnectorRequest req) throws IOException {
        JsonNode node = (JsonNode)p.getCodec().readTree(p);
        JsonNode connectorNode = node.at("/connector");
        if (req.connector == null) {
            ConnectorType connectorType = ConnectorJacksonHelper.extractType(ctxt, p, connectorNode);
            req.connector = ConnectorJacksonHelper.newConnector(connectorType);
        }
        if (p.getCodec() instanceof ObjectMapper) {
            ((ObjectMapper)p.getCodec()).readerForUpdating((Object)req.connector).readValue(connectorNode);
        } else if (p.getCodec() instanceof ObjectReader) {
            req.connector = (BaseConnectorConfiguration)((ObjectReader)p.getCodec()).readValue(connectorNode, req.connector.getClass());
        }
        return req;
    }
}

