/*
 * Decompiled with CFR 0.152.
 */
package io.fusionauth.client;

import io.fusionauth.jwt.domain.JWT;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class JWTManager {
    private static final ScheduledThreadPoolExecutor executorService;
    private static final Map<UUID, ZonedDateTime> revokedByApplication;
    private static final Map<UUID, Map<UUID, ZonedDateTime>> revokedByUser;
    private static final Map<UUID, ZonedDateTime> revokedRefreshTokens;

    public static boolean isValid(JWT jwt) {
        boolean result;
        ZonedDateTime expiration;
        try {
            String refreshTokenId = jwt.getString("sid");
            if (refreshTokenId != null && (expiration = revokedRefreshTokens.get(UUID.fromString(refreshTokenId))) != null && !(result = expiration.isBefore(jwt.expiration))) {
                return false;
            }
        }
        catch (Exception refreshTokenId) {
            // empty catch block
        }
        try {
            String applicationId = jwt.getString("applicationId");
            if (applicationId != null) {
                Map<UUID, ZonedDateTime> context;
                expiration = revokedByApplication.get(UUID.fromString(applicationId));
                if (expiration != null && !(result = expiration.isBefore(jwt.expiration))) {
                    return false;
                }
                String userId = jwt.subject;
                if (userId != null && (context = revokedByUser.get(UUID.fromString(userId))) != null && (expiration = context.get(UUID.fromString(applicationId))) != null && !(result = expiration.isBefore(jwt.expiration))) {
                    return false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static void reset() {
        revokedByApplication.clear();
        revokedByUser.clear();
        revokedRefreshTokens.clear();
    }

    public static void revokeByApplication(UUID applicationId, int durationsInSeconds) {
        ZonedDateTime expiration = ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(durationsInSeconds);
        revokedByApplication.put(applicationId, expiration);
    }

    public static void revokeByRefreshToken(UUID refreshTokenId, int durationInSeconds) {
        ZonedDateTime expiration = ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(durationInSeconds);
        revokedRefreshTokens.put(refreshTokenId, expiration);
    }

    public static void revokedByUser(UUID userId, Map<UUID, Integer> durationsInSeconds) {
        Map context = revokedByUser.computeIfAbsent(userId, key -> new HashMap());
        for (UUID applicationId : durationsInSeconds.keySet()) {
            ZonedDateTime expiration = ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(durationsInSeconds.get(applicationId).intValue());
            context.put(applicationId, expiration);
        }
    }

    static {
        revokedByApplication = new ConcurrentHashMap<UUID, ZonedDateTime>();
        revokedByUser = new ConcurrentHashMap<UUID, Map<UUID, ZonedDateTime>>();
        revokedRefreshTokens = new ConcurrentHashMap<UUID, ZonedDateTime>();
        executorService = new ScheduledThreadPoolExecutor(1, r -> {
            Thread t = new Thread(r);
            t.setName("JWTManager Thread");
            t.setDaemon(true);
            return t;
        });
        executorService.schedule(() -> {
            ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
            revokedByUser.values().forEach(m -> m.entrySet().removeIf(e -> ((ZonedDateTime)e.getValue()).isBefore(now)));
            revokedByApplication.entrySet().removeIf(e -> ((ZonedDateTime)e.getValue()).isBefore(now));
            revokedRefreshTokens.entrySet().removeIf(e -> ((ZonedDateTime)e.getValue()).isBefore(now));
        }, 7L, TimeUnit.SECONDS);
    }
}

